static UINT32 r2d_lcd_copy_operator(UINT32 old,UINT32 value)
{
	return(value);
}
static UINT32 r2d_lcd_or_operator(UINT32 old,UINT32 value)
{
	return(old | value) ;
}
static UINT32 r2d_lcd_and_operator(UINT32 old,UINT32 value)
{
	return(old & value);
}
static UINT32 r2d_lcd_xor_operator(UINT32 old,UINT32 value)
{
	return(old ^ value) ;
}
static UINT32 r2d_lcd_not_copy_operator(UINT32 old,UINT32 value)
{
	return(~value);
}
static UINT32 r2d_lcd_not_or_operator(UINT32 old,UINT32 value)
{
	return(~(old | value));
}
static UINT32 r2d_lcd_not_and_operator(UINT32 old,UINT32 value)
{
	return(~(old & value));
}
static UINT32 r2d_lcd_not_xor_operator(UINT32 old,UINT32 value)
{
	return(~(old ^ value)) ;
}

const T_R2D_DRAWING_OPERATORS r2d_g_lcd_operators=
{
   &r2d_lcd_copy_operator,
   &r2d_lcd_or_operator,
   &r2d_lcd_and_operator,
   &r2d_lcd_xor_operator,
   &r2d_lcd_not_copy_operator,
   &r2d_lcd_not_or_operator,
   &r2d_lcd_not_and_operator,
   &r2d_lcd_not_xor_operator,
   NULL
};

// Return the pixel value to write on the LCD or the offscreen
// pixmap
// LCD DEPENDENT
void r2d_convert_foreground_color(T_R2D_GC *gc,UINT32 color)
{
     
     // If one is writing to the LCD framebuffer (the only
     // one which is not 24 bits) then color conversion is required
        UINT16 red,green,blue;
        UINT32 lightness;

      
        red=r2d_red(color);
        green=r2d_green(color);
        blue=r2d_blue(color);

        // Compute global intensity for monochrome LCD
        lightness=(~((r2d_max_color(red,green,blue) + r2d_min_color(red,green,blue)) >> 1) & 0xFF);       

  #if (R2D_DITHERING == R2D_ON)
        {
          UINT32 dvalue;
          UINT16 dithering_group;

          r2d_dithering_group_and_lightness();

          r2d_dithered_value(0,0)
          r2d_set_dithering_matrix_entry(gc->p_foreground_dithered_cache,
            dvalue,0,0);

          r2d_dithered_value(0,1)
          r2d_set_dithering_matrix_entry(gc->p_foreground_dithered_cache,
            dvalue,0,1);

          r2d_dithered_value(1,1)
          r2d_set_dithering_matrix_entry(gc->p_foreground_dithered_cache,
            dvalue,1,1);

          r2d_dithered_value(1,0)
          r2d_set_dithering_matrix_entry(gc->p_foreground_dithered_cache,
            dvalue,1,0);


        }
  #else
          lightness=(lightness >> (8 - R2D_PIXEL_DEPTH)) & R2D_PIXEL_MASK;
          gc->foreground_pixel_value=lightness;
  #endif

     
     
}

// Return the pixel value to write on the LCD or the offscreen
// pixmap
// LCD DEPENDENT
void r2d_convert_background_color(T_R2D_GC *gc,UINT32 color)
{
     
     // If one is writing to the LCD framebuffer (the only
     // one which is not 24 bits) then color conversion is required
        UINT16 red,green,blue;
        UINT32 lightness;

      
        red=r2d_red(color);
        green=r2d_green(color);
        blue=r2d_blue(color);

        // Compute global intensity for monochrome LCD
        lightness=(~((r2d_max_color(red,green,blue) + r2d_min_color(red,green,blue)) >> 1) & 0xFF);       

  #if (R2D_DITHERING == R2D_ON)
        {
          UINT32 dvalue;
          UINT16 dithering_group;

          r2d_dithering_group_and_lightness();

          r2d_dithered_value(0,0)
          r2d_set_dithering_matrix_entry(gc->p_background_dithered_cache,
            dvalue,0,0);

          r2d_dithered_value(0,1)
          r2d_set_dithering_matrix_entry(gc->p_background_dithered_cache,
            dvalue,0,1);

          r2d_dithered_value(1,1)
          r2d_set_dithering_matrix_entry(gc->p_background_dithered_cache,
            dvalue,1,1);

          r2d_dithered_value(1,0)
          r2d_set_dithering_matrix_entry(gc->p_background_dithered_cache,
            dvalue,1,0);


        }
  #else
          lightness=(lightness >> (8 - R2D_PIXEL_DEPTH)) & R2D_PIXEL_MASK;
          gc->background_pixel_value=lightness;
  #endif


     
     
     
}

// blit_rect may use the foreground and background color
// to do the copy. So, one must knows which source pixels
// are corresponding to the background color,
// which ones are corresponding to the foreground color
// and do the conversion of the color selected
// according to the destination framebuffer

// This files gives routines for:
//  - Selecting a color according to the value in the LCD framebuffer
//  - Converting a color to LCD


// Convert a LCD value (not color) to a value
// to be written into the 24bpp framebuffer
// In general, the value written is a packed
// representation of the ARGB color
// but it may be different according to the framebuffer
// internal format
BOOLEAN r2d_lcd_foreground_pixel(UINT32 lcd_value,T_R2D_GC_PTR src_gc)
{
   if (lcd_value)
    return(TRUE); // Foreground pixel
   else
    return(FALSE); // Background pixel
}

// Assume than color framebuffer contains ARGB packed values
// Convert color to LCD with on the fly dithering
UINT32 r2d_color_to_lcd(UINT32 pixel_value,INT16 x,INT16 y)
{

  INT16 red,green,blue;
  UINT32 lightness;
  UINT32 dvalue;
  UINT16 dithering_group;

  pixel_value=(~pixel_value) & 0x00FFFFFF;
  red=r2d_red(pixel_value);
  green=r2d_green(pixel_value);
  blue=r2d_blue(pixel_value);

  // Compute global intensity for monochrome LCD
  lightness=(~((r2d_max_color(red,green,blue) + r2d_min_color(red,green,blue)) >> 1) & 0xFF);       
 

  r2d_dithering_group_and_lightness();

  r2d_dithered_value(x & 1,y & 1);
          
  return(dvalue);
}

// Lcd to pixel value
UINT32 r2d_lcd_to_color(UINT32 color)
{
    
  if (color)
    return(0x00FFFFFF); // 24 bpp framebuffer pixel value for white
  else
	return(0x00000000);
}



