static UINT32 r2d_lcd_copy_operator(UINT32 old,UINT32 value)
{
	return(value);
}
static UINT32 r2d_lcd_or_operator(UINT32 old,UINT32 value)
{
	if ((value&0x00FFFFFF)==0x0FFFFFF)
		return(old);
	else
	    return(value);
}
static UINT32 r2d_lcd_and_operator(UINT32 old,UINT32 value)
{
	return((~(~old) & (~value)));
}
static UINT32 r2d_lcd_xor_operator(UINT32 old,UINT32 value)
{
	return(~((~old) ^ (~value))) ;
}
static UINT32 r2d_lcd_not_copy_operator(UINT32 old,UINT32 value)
{
	return(~value);
}
static UINT32 r2d_lcd_not_or_operator(UINT32 old,UINT32 value)
{
	return(((~old) | (~value)));
}
static UINT32 r2d_lcd_not_and_operator(UINT32 old,UINT32 value)
{
	return(((~old) & (~value)));
}
static UINT32 r2d_lcd_not_xor_operator(UINT32 old,UINT32 value)
{
	return(((~old) ^ (~value))) ;
}

static UINT32 r2d_lcd_erase_operator(UINT32 old,UINT32 value)
{
	if ((value&0x00FFFFFF)==0)
		return(0xFFFFFF);
	else
	    return(old);
}

static UINT32 r2d_lcd_alpha_operator(UINT32 old,UINT32 value)
{
			   INT16 a,rs,gs,bs,rd,gd,bd;

			   

			   a=(value >> 24) & 0x0FF;
			   

			   if (a)
			   {

			   bs=value&0xFF;
			
			   value=value>>8;
			   gs=value&0xFF;

			   value=value>>8;
			   rs=value&0xFF;
			   
			   bd=old&0xFF;
			
			   old=old>>8;
			   gd=old&0xFF;

			   old=old>>8;
			   rd=old&0xFF;
			   
			   // Pixel value has been complemented before being
			   // saved so that the white correspond to 0 and be
			   // compatible with formulas for other modes.
			   // But alpha value is not complemented
			   // So a=0xFF correspond tranparency
			   bd=((a)*bd+(0x100 - a)*bs) >> 8;
			   gd=((a)*gd+(0x100 - a)*gs) >> 8;
			   rd=((a)*rd+(0x100 - a)*rs) >> 8;

			   
			   old=((rd << 16) | (gd << 8) | bd) & 0x00FFFFFF;
			   return(old);
			   }
			   else return(value);
}

const T_R2D_DRAWING_OPERATORS r2d_g_lcd_operators=
{
   &r2d_lcd_copy_operator,
   &r2d_lcd_or_operator,
   &r2d_lcd_and_operator,
   &r2d_lcd_xor_operator,
   &r2d_lcd_not_copy_operator,
   &r2d_lcd_not_or_operator,
   &r2d_lcd_not_and_operator,
   &r2d_lcd_not_xor_operator,
   &r2d_lcd_alpha_operator,
   &r2d_lcd_erase_operator
};



		  




// Return the pixel value to write on the LCD or the offscreen
// pixmap
// (Convert Riviera color to Windows RGB Format with complement)
void r2d_convert_foreground_color(T_R2D_GC *gc,UINT32 color)
{
	/*gc->foreground_pixel_value=r2d_alpha(color);
    gc->foreground_pixel_value<<=24;

    gc->foreground_pixel_value|=((RGB(r2d_red(color),
		r2d_green(color),r2d_blue(color)))) & 0x00FFFFFF;*/
    
     gc->foreground_pixel_value=color;
}

// Return the pixel value to write on the LCD or the offscreen
// pixmap
// (Convert ribviera color to windows RGB format with complement)
void r2d_convert_background_color(T_R2D_GC *gc,UINT32 color)
{
    /*gc->background_pixel_value=r2d_alpha(color);
    gc->background_pixel_value<<=24;

     gc->background_pixel_value|=((RGB(r2d_red(color),
		r2d_green(color),r2d_blue(color)))) & 0x00FFFFFF;*/
     
     gc->background_pixel_value=color;
}

// Convert a LCD value (not color) to a value
// to be written into the 24bpp framebuffer
// In general, the value written is a packed
// representation of the ARGB color
// but it may be different according to the framebuffer
// internal format
BOOLEAN r2d_lcd_foreground_pixel(UINT32 lcd_value,T_R2D_GC_PTR src_gc)
{
   if (lcd_value&0x0FFFFFF==0x0FFFFFF)
    return(FALSE);
   else
    return(TRUE);
}

// Assume than color framebuffer contains ARGB packed values
// Convert color to LCD with on the fly dithering
// Riviera complemented RGB to Windows complemented one
// Convert from pixel_value to LCD
UINT32 r2d_color_to_lcd(UINT32 pixel_value,INT16 x,INT16 y)
{
  return((((~pixel_value)&0x00FFFFFF)) | (pixel_value&0xFF000000));
}

// Windows RGB format to pixel value for 24 bpp framebuffer
UINT32 r2d_lcd_to_color(UINT32 color)
{
    
//  INT16 r,g,b;
//  UINT32 a;

  /*a=color&0xFF000000;

  color=color;
  r=GetRValue(color);
  g=GetGValue(color);
  b=GetBValue(color);

  return(((~((r<<16) + (g<<8)+b)) & 0x00FFFFFF) | a);*/
  return((~(color&0xFFFFFF)) | (color&0xFF000000));
}


