/* Used by refresh task to extract bytes from the
framebuffer */


 
                
#define R2D_MB_PRIM_SIZE 3000


#define MASTER_CMD(data) *(volatile unsigned char*)0x2000005 = (data)
#define MASTER_DATA(data) *(volatile unsigned char*)0x2000004 = (data)
#define SLAVE_CMD(data) *(volatile unsigned char*)0x2000003 = (data)
#define SLAVE_DATA(data) *(volatile unsigned char*)0x2000002 = (data)


static void r2d_refresh_task_init(void)
{

	INT16 x,y;

#ifndef _WINDOWS
	// Coded on 5 bits for the wait states
    //*(volatile short*)0xfffffb0a = 0xe80 | 0x1f; // max waitstates and dummy cycles on CS3 and CS4
	//*(volatile short*)0xfffffb06 = 0xe80 | 0x1f; // and config. as 8-bit I/O
    
	*(volatile short*)0xfffffb0a = 0xe80 | 0x3; // max waitstates and dummy cycles on CS3 and CS4
	*(volatile short*)0xfffffb06 = 0xe80 | 0x3; // and config. as 8-bit I/O
    
	MASTER_CMD(0xF4);  // RE register set
    MASTER_CMD(0xB6);  // electronic volume set (lower) (b5)
    MASTER_CMD(0xA0);  // electronic volume set (upper) (a9)
    MASTER_CMD(0xF0);  // RE register set
    MASTER_CMD(0xE2);  // Bias ratio set = 1/7 (e2)
    MASTER_CMD(0xD3);  // Booster set = 4x
    MASTER_CMD(0x66);  // 7 line alternated
    MASTER_CMD(0x70);  // 7 line alternated
  
    MASTER_CMD(0xBA);  // power control (DC, AMP = ON)
    
    for (x=0;x<300;x++)
      for (y=0;y<300;y++) ;    // Delay while initializing
  
  //functions master
    MASTER_CMD(0xf4);  // RE register set
    MASTER_CMD(0x60);  // common start line
    MASTER_CMD(0xf0);  // RE register set
    MASTER_CMD(0x40);  // display start line lower
    MASTER_CMD(0x50);  // display start line upper
    MASTER_CMD(0xc7);  // display duty cycle = 1/66
  
  //functions slave
    SLAVE_CMD(0xf4);  // RE register set
    SLAVE_CMD(0x60);  // common start line
    SLAVE_CMD(0xf0);  // RE register set
    SLAVE_CMD(0x40);  // display start line lower
    SLAVE_CMD(0x50);  // display start line upper
    SLAVE_CMD(0xc7);  // display duty cycle = 1/66
  
    MASTER_CMD(0x81);  // display ON master
    SLAVE_CMD(0x89);  // display ON slave (89)
#endif
}

static void r2d_refresh_task_kill(void)
{
}

static void r2d_dithering_init(void)
{
   R2D_MALLOC(r2d_mb_id,UINT32,sizeof(UINT32)*4,r2d_g_dithering_matrix);
   if (r2d_g_dithering_matrix!=NULL)
   {
     r2d_g_dithering_matrix[0]=0;
     r2d_g_dithering_matrix[1]=2;
     r2d_g_dithering_matrix[2]=3;
     r2d_g_dithering_matrix[3]=1;
   }
}
