#define MASTER_CMD(data) *(volatile unsigned char*)0x2000005 = (data)
#define MASTER_DATA(data) *(volatile unsigned char*)0x2000004 = (data)
#define SLAVE_CMD(data) *(volatile unsigned char*)0x2000003 = (data)
#define SLAVE_DATA(data) *(volatile unsigned char*)0x2000002 = (data)

void r2d_lcd_power_on(void)
{
}

void r2d_lcd_power_off(void)
{
}

void r2d_refresh(void)
{
	INT16 x,y;

    UINT32 v;

    UINT32  *mp,*sp;
	UINT32 mtmp,stmp;

	

#ifndef _WINDOWS	
  MASTER_CMD(0xF0);  // RE register set
  MASTER_CMD(0xA3);  // Auto incremnent
  MASTER_CMD(0x00);  // X Address set (lower)
  MASTER_CMD(0x10);  // X Address set (upper)
  MASTER_CMD(0x20);  // Y Address set (lower)
  MASTER_CMD(0x30);  // Y Address set (upper)
  MASTER_CMD(0x97);  // Display control

  //position slave
  SLAVE_CMD(0xF0);  // RE register set
  SLAVE_CMD(0xA3);  // Auto incremnent
  SLAVE_CMD(0x00);  // X Address set (lower)
  SLAVE_CMD(0x10);  // X Address set (upper)
  SLAVE_CMD(0x20);  // Y Address set (lower)
  SLAVE_CMD(0x30);  // Y Address set (upper)
  SLAVE_CMD(0x96);  // Display control
#endif
    	
    // rvf_send_trace("R2D REFRESH",strlen("R2D REFRESH"), NULL_PARAM, 
	//		   RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_XXX );

	mp=r2d_g_framebuffer->p_memory_words;

	// One word added by computation of R2D_MWWIDTH
	// so 49 used instead of 48
	sp=mp+(64*49);


	
    
	for (y=0;y<64;y++)
	{
	  for  (x=0; x<48;x++)
      {

		mtmp=~(*mp++);
		stmp=~(*sp++);

        MASTER_DATA(mtmp&0xFF);
        SLAVE_DATA(stmp&0xFF);
#ifndef _WINDOWS
		mtmp>>=16;
		stmp>>=16;
		MASTER_DATA(mtmp&0xFF);
        SLAVE_DATA(stmp&0xFF);

#endif
      }
	  // R2D_MWWIDTH is one word larger than the real LCD size
	  // so when refreshing that must be taken into account
	  *mp++;
	  *sp++;
	}

   // Finish sending datas to LCD
   
   r2d_reinit_update_region();
#ifdef _WINDOWS
	lcd_refresh();
#endif
}