#!perl

# Mode os scanning (vertical or horizontal)
$mode=$ARGV[0];

# Name of file used to transfer data between this script and the r2d_font_tool
$data=$ARGV[1];

if (($#ARGV+1)>2)
{
   $x=$ARGV[3];
   open(DATA,">$data") or die "Cannot create data file : $!\n";
   $words = int($x/2)+1;

# One word must be added because the alignement is done by excess   
   print DATA $words;
   close(DATA);

   
}
     else
     {
# Open the data file to import glyph bit matrix generated by r2d_font_tool
open(DATA,"$data") or die "Cannot open input file : $!\n";

# It is the size unmodified by r2d_font_tool (width in vertical mode and
# height in horizontal mode). It corresponds to the width/height for the
# current glyph
$matrix_size=int(<DATA>);

# It is the size which is word aligned by r2d_font_tool (height in 
# vertical mode and width in horizontal one)
# It corresponds to the max width/height on all fonts.
$matrix_aligned_size=int(<DATA>);

# Original value before word alignment
# (Max value on all glyphs before alignment) 
$matrix_max_size=int(<DATA>);

# Width of the glyph image in the bitmap
$matrix_image_width=int(<DATA>);

# Height of the glyph in the bitmap
$matrix_image_height=int(<DATA>);

if ($mode =~ /vertical/)
{
   # Scanning of the glyph bit matrix done column per column
   # (since datas are saved column per column by r2d_font_tool
   # when in horizontal mode)
   for($i=0;$i<$matrix_size;$i++)
   {
      for($j=0;$j<$matrix_aligned_size;$j++)
      {
         $matrix{$i.".".$j}=int(<DATA>); 
      }
   }
}
else
{
   # Scanning of the glyph bit matrix done line per line
   for($i=0;$i<$matrix_aligned_size;$i++)
   {
      for($j=0;$j<$matrix_size;$j++)
      {
         $matrix{$i.".".$j}=int(<DATA>); 
      }
   }
}
close(DATA);


# That part of the code is translating the glyph (initially represented
# as a bit matrix) to a format which is compatible with the current LCD.
#
# In this example, the LCD is a 24 bpp one. So, a bit 0 (correponding to black)
# must be converted to 0, and 1 (for white) to 0xFFFFFF.
#
# The scanning must use the IMAGE width in  vertical mode
# and the IMAGE height in horizontal mode.

# In vertical mode, the height must use max_size on all glyph
# In horizontal mode, the width must use the max_size.
# You can either use the aligned_version if you LCD is a 1bpp one and
# or you can use the non aligned one (matrix_max_size) and do the alignment 
# yourself.

# In our case, the LCD is a 24bpp, so no alignment is required and the
# max_size is used directly.

$words=int(($matrix_max_size/2)) + 1;
$aligned=$words*2;

open(DATA,">$data") or die "Cannot create data file : $!\n";
  if ($mode =~ /vertical/)
  {
    # Scanning column per column
    for($i=0;$i<$matrix_image_width;$i++)
    {
      for($j=0;$j<$aligned/2;$j++)
      {
         $pos=2*$j;
         $npos=$pos+1;
         $ra=$matrix{$i.".".$pos};
         $rb=$matrix{$i.".".$npos};

         # Conversion of bit to color value
         if ($ra != 0)
         {
            $ra=0x0FF;
         }
         else
         {
            $ra=0;
         }

         if ($rb != 0)
         {
            $rb=0x0FF0000;
         }
         else
         {
            $rb=0;
         }         

    $rb=$rb | $ra;
         $res=sprintf "0x%08X\n",$rb;
         print DATA $res;
      }
    }
  }
  else
  {
    # Scanning line per line
    for($j=0;$j<$matrix_image_height;$j++)
    {
      for($i=0;$i<$aligned/2;$i++)
      {
         $pos=2*$i;
         $npos=$pos+1;
         $ra=$matrix{$pos.".".$j};
         $rb=$matrix{$npos.".".$j};

         # Conversion of bit to color value
         if ($ra != 0)
         {
            $ra=0x0FF;
         }
         else
         {
            $ra=0;
         }

         if ($rb != 0)
         {
            $rb=0x0FF0000;
         }
         else
         {
            $rb=0;
         }         

    $rb=$rb | $ra;
         $res=sprintf "0x%08X\n",$rb;
         print DATA $res;
      }
    }
  }
close(DATA);
}
