

static UINT32 r2d_lcd_copy_operator(UINT32 old,UINT32 value)
{
	return(value);
}
static UINT32 r2d_lcd_or_operator(UINT32 old,UINT32 value)
{
	if ((value&0x0FF)==0)
		return(old);
	else
	    return(value);
}
static UINT32 r2d_lcd_and_operator(UINT32 old,UINT32 value)
{
	return(old & value);
}
static UINT32 r2d_lcd_xor_operator(UINT32 old,UINT32 value)
{
	return(old ^ value) ;
}
static UINT32 r2d_lcd_not_copy_operator(UINT32 old,UINT32 value)
{
	return(~value);
}
static UINT32 r2d_lcd_not_or_operator(UINT32 old,UINT32 value)
{
	return(~(old | value));
}
static UINT32 r2d_lcd_not_and_operator(UINT32 old,UINT32 value)
{
	return(~(old & value));
}
static UINT32 r2d_lcd_not_xor_operator(UINT32 old,UINT32 value)
{
	return(~(old ^ value)) ;
}
static UINT32 r2d_lcd_erase_operator(UINT32 old,UINT32 value)
{
	if ((value&0x0FF)==0xFF)
		return(0);
	else
	    return(old);
}


UINT32 r2d_lcd_alpha_operator(UINT32 old,UINT32 value)
{
			   INT16 a,rs,gs,bs,rd,gd,bd;

			   a=(value >> 8) & 0x0FF;

			   if (a)
			   {

			   value=(~value) & 0xFF;
			   old=(~old) & 0xFF;
			   
			   
			   bs=value&0x3;
               value=value>>2;
               gs=value&7;
               value=value>>3;
               rs=value&7;


			   bd=old&0x3;
               old=old>>2;
               gd=old&7;
               old=old>>3;
               rd=old&7;
			   
			   // Pixel value has been complemented before being
			   // saved so that the white correspond to 0 and be
			   // compatible with formulas for other modes.
			   // But alpha value is not complemented
			   // So a=0xFF correspond tranparency
			   bd=((a)*bd+(0x100 - a)*bs) >> 8;
			   gd=((a)*gd+(0x100 - a)*gs) >> 8;
			   rd=((a)*rd+(0x100 - a)*rs) >> 8;

			   rd=rd<<5;
			   gd=gd<<2;

			   old=(~(rd|gd|bd)) & 0x00FF;
			   return(old);
			   }
			   else
				   return(value);
}
 

const T_R2D_DRAWING_OPERATORS r2d_g_lcd_operators=
{
   &r2d_lcd_copy_operator,
   &r2d_lcd_or_operator,
   &r2d_lcd_and_operator,
   &r2d_lcd_xor_operator,
   &r2d_lcd_not_copy_operator,
   &r2d_lcd_not_or_operator,
   &r2d_lcd_not_and_operator,
   &r2d_lcd_not_xor_operator,
   &r2d_lcd_alpha_operator,
   &r2d_lcd_erase_operator
};


// Return the pixel value to write on the LCD or the offscreen
// pixmap
// (Convert Riviera color to Windows RGB Format with complement)
void r2d_convert_foreground_color(T_R2D_GC *gc,UINT32 color)
{
	INT16 r,g,b,a;

	gc->foreground_pixel_value=0;
    
	a=(r2d_alpha(color)) <<8;
	gc->foreground_pixel_value|=a;

	r=(r2d_red(color)) >> 5;
	g=(r2d_green(color)) >> 5;
	b=(r2d_blue(color)) >> 6;

    gc->foreground_pixel_value|= (~((r<<5) | (g<<2) | b)) & 0x0FFFF;
    
     
}

// Return the pixel value to write on the LCD or the offscreen
// pixmap
// (Convert riviera color to windows RGB format with complement)
void r2d_convert_background_color(T_R2D_GC *gc,UINT32 color)
{
    INT16 r,g,b,a;

	gc->background_pixel_value=0;

	a=(r2d_alpha(color)) <<8;
	gc->background_pixel_value|=a;
    
	r=(r2d_red(color)) >> 5;
	g=(r2d_green(color)) >> 5;
	b=(r2d_blue(color)) >> 6;

    gc->background_pixel_value|= (~((r<<5) | (g<<2) | b)) & 0xFF;
     
}



// Convert a LCD value (not color) to a value
// to be written into the 24bpp framebuffer
// In general, the value written is a packed
// representation of the ARGB color
// but it may be different according to the framebuffer
// internal format
BOOLEAN r2d_lcd_foreground_pixel(UINT32 lcd_value,T_R2D_GC_PTR src_gc)
{
   if (lcd_value)
    return(TRUE);
   else
    return(FALSE);
}

// Color framebuffer to color LCD
UINT32 r2d_color_to_lcd(UINT32 pixel_value,INT16 x,INT16 y)
{
  
  INT16 red,green,blue;
  UINT32 alpha;

  alpha=pixel_value & 0xFF000000;
  alpha=alpha >> 16;
  

  pixel_value=(~pixel_value) & 0x00FFFFFF;
  red=r2d_red(pixel_value);
  green=r2d_green(pixel_value);
  blue=r2d_blue(pixel_value);

  red=red>>5;
  green=green>>5;
  blue=blue>>6;
  
  return(((~((red<<5) | (green << 2) | blue)) & 0x00FF) | alpha);
}

// Color LCD to color framebuffer
UINT32 r2d_lcd_to_color(UINT32 color)
{
    
  INT16 r,g,b;
  UINT32 alpha;

  alpha=color & 0xFF00;
  alpha=alpha << 16;

  color=~color;
  b=color&0x3;
  color=color>>2;
  g=color&7;
  color=color>>3;
  r=color&7;

  b=b<<6;
  g=g<<5;
  r=r<<5;

  return(((~((r<<16) + (g<<8)+b)) & 0x00FFFFFF) | alpha);
}


