#!perl

$in=$ARGV[0];
$out=$ARGV[1];

$nin = $in;

$nin =~ s/\..*$/.txt/;

#print "->$nin";

print "convert -modulate 160 -colors 256 -dither $in TEXT:$nin\n";
system("convert -modulate 160 -colors 256 -dither $in TEXT:$nin");

$maxx=0;
$maxy=0;
open(IN,$nin) or die "Cannot read input file:$! \n";
while($line=<IN>)
{
if ($line =~ /^([0-9]+),([0-9]+):[\s\t]*([0-9]+),([0-9]+),([0-9]+)[\s\t]*.*$/)
{
$x=int($1);
$y=int($2);
$r=int($3);
$g=int($4);
$b=int($5);
if ($x>$maxx)
{
$maxx=$x;
}

if ($y>$maxy)
{
$maxy=$y;
}

$b=$b >> 14;
$g=$g >> 13;
$r=$r >> 13;

$value = ($r << 5) | ($g << 2) | $b;

$data{$x.":".$y}=$value;


}
}
close(IN);

$maxx=$maxx+1;
$maxy=$maxy+1;

open(OUT,">$out.c") or die "Cannot create outputfile: $!\n";

$length=(($maxy/2)+1)*$maxx;

print OUT "const UINT32 $out"."[]={\n";
print OUT "$maxx,$maxy,$length,\n";
for($i=0;$i<$maxx;$i++)
{
  for($j=0;$j<($maxy/2)+1;$j++)
{
  $y=2*$j;

  if (exists $data{$i.":".$y})
  {
     $ra=  (~$data{$i.":".$y}) & 0x0FF;
  }
  else
  {
     $ra=0x0000;
  }
  $y=$y+1;
  if (exists $data{$i.":".$y})
  {
     $rb=  (~$data{$i.":".$y}) & 0x0FF;
  }
  else
  {
     $rb=0x0000;
  }
  

  $value=($rb<<16) | $ra;
  $result=sprintf "0x%08X",$value;
  print OUT "$result,\n";
}
}
print OUT "0x0\n";
print OUT "};\n";
close(OUT);

#rename "$out.c","E:\\BT\\Drivers\\Common\\R2D\\$out.c"
