/* Used by refresh task to extract bytes from the
framebuffer */

#include "r2d/lcds/bw_d_sample/r2d_tfd_lcd.h"

#include "main/sys_types.h"
#include "l1_types.h"
#include "memif/mem.h"


#define R2D_MB_PRIM_SIZE	(4000)
 

const unsigned char INIT_DISCTL[11] = { 0xDE,0x01,0x64,0x00,0x1B,0xF4,0x00,0xDC,0x00,0x02,0x00};

const unsigned char INIT_GCP64[126] = {
		0x15,0x00,0x29,0x00,0x3E,0x00,0x51,0x00,		0x65,0x00,0x7A,0x00,0x8D,0x00,0XA1,0x00,
		0XB6,0x00,0XC7,0x00,0XD8,0x00,0XEB,0x00,		0XFB,0x00,0x0B,0x01,0X1B,0x01,0X27,0x01,
		0x34,0x01,0x41,0x01,0x4C,0x01,0x55,0x01,		0x5F,0x01,0x68,0x01,0x70,0x01,0x78,0x01,
		0x7E,0x01,0x86,0x01,0x8C,0x01,0x94,0x01,		0x9B,0x01,0XA1,0x01,0xA4,0x01,0xA9,0x01,
		0xAD,0x01,0xB2,0x01,0xB7,0x01,0xBC,0x01,		0xC0,0x01,0xC4,0x01,0xC8,0x01,0xCB,0x01,
		0xCF,0x01,0xD2,0x01,0xD5,0x01,0xD8,0x01,		0xDB,0x01,0xE0,0x01,0xE3,0x01,0xE6,0x01,
		0xE8,0x01,0xEB,0x01,0xEE,0x01,0xF1,0x01,		0xF3,0x01,0xF8,0x01,0xF9,0x01,0xFC,0x01,
		0x00,0x02,0x03,0x02,0x07,0x02,0x09,0x02,		0x0E,0x02,0x13,0x02,0x1C,0x02 };
const unsigned char INIT_GCP16[15] = {
	0x1A,0x31,0x48,0x54,0x5F,0x67,0x70,0x76,0x7C,0x80,0x83,0x84,0x85,0x87,0x96 };

const unsigned char INIT_MD_PSET[4] = { 0x00, 0x01, 0x00, 0x01 };
const unsigned char INIT_MD_CSET[4] = { 0x00, 0x02, 0x00, 0x02 };

const unsigned char INIT_SD_PSET[4] = { 0, 0, 219, 0 };
const unsigned char INIT_SD_CSET[4] = { 2, 0, 177, 0 };

const unsigned char INIT_ASCSET[7] = { 0x00, 0x00, 0xDB, 0x00, 0xDC, 0x00, 0x01 };
const unsigned char INIT_SCSTART[2] = { 0x00, 0x00 };

static void r2d_nop_delay(UINT32 ms)
{
    unsigned short a;
    while (ms-- > 0) for (a=0;a<1000;a++) asm(" nop");
}

 void r2d_refresh_task_init(void)
{

#ifndef _WINDOWS

  UINT32  i;

  LCD_activate;

  LCD_cmd(LCD_DISOFF);
  LCD_cmd(LCD_SLPIN);
  LCD_cmd(LCD_DISNOR);
  LCD_cmd(LCD_GSSET);
  LCD_data(INIT_GSSET); // 64 gradients

  r2d_nop_delay(100);

	
	LCD_cmd(LCD_DISCTL);	 // Init LCD controller
	for (i=0; i<11; i++)	LCD_data(INIT_DISCTL[i]);

	LCD_cmd(LCD_GCP64); 	// Init palette for 64 gradient palette
	for (i=0; i<126; i++)  LCD_data(INIT_GCP64[i]);

	LCD_cmd(LCD_GCP16); 	// Init palette for 16 gradient palette

	for (i=0; i<15; i++)	LCD_data(INIT_GCP16[i]);

	LCD_cmd(LCD_MD_CSET);  // set area devoted to DSP interface
	for (i=0; i<4; i++)  LCD_data(INIT_MD_CSET[i]);

	LCD_cmd(LCD_MD_PSET);  // set area devoted to DSP interface

	for (i=0; i<4; i++)  LCD_data(INIT_MD_PSET[i]);

	LCD_cmd(LCD_SD_CSET);  // set area devoted to MPU interface
	for (i=0; i<4; i++)  LCD_data(INIT_SD_CSET[i]);

	LCD_cmd(LCD_SD_PSET);  // set area devoted to MPU interface
	for (i=0; i<4; i++)  LCD_data(INIT_SD_PSET[i]);

	LCD_cmd(LCD_DATCTL);
	LCD_data(INIT_DATCTL);//0x08);

	LCD_cmd(LCD_OSCISEL);
	LCD_data(INIT_OSCISEL);//0x05);

	LCD_cmd(LCD_14MSET);
	LCD_data(INIT_14MSET);//0x4B);

	LCD_cmd(LCD_14MEND);

	LCD_cmd(LCD_3500KSET);
	LCD_data(INIT_3500KSET);//0x45);

	LCD_cmd(LCD_3500KEND);

	r2d_nop_delay(30);

	LCD_cmd(LCD_SLPOUT);

	r2d_nop_delay(20);

	LCD_cmd(LCD_VOLCTL);
	LCD_data(INIT_VOLCTL_Ton);// 152);

	r2d_nop_delay(20);

	LCD_cmd(LCD_VOLCTL);
	LCD_data(INIT_VOLCTL);

	r2d_nop_delay(20);
	LCD_cmd(LCD_DISON);

	LCD_cmd(LCD_RAMWR);

	  for (i=0; i<176*220; i++)
	  {
		//LCD_data(pic_data[i]);
		// Try filling with white color
		LCD_data(0x1F);
	  }

	

	LCD_deactivate;

#endif
}

static void r2d_refresh_task_kill(void)
{
}

static void r2d_dithering_init(void)
{
   R2D_MALLOC(r2d_mb_id,UINT32,sizeof(UINT32)*4,r2d_g_dithering_matrix);
   if (r2d_g_dithering_matrix!=NULL)
   {
     r2d_g_dithering_matrix[0]=0;
     r2d_g_dithering_matrix[1]=2;
     r2d_g_dithering_matrix[2]=3;
     r2d_g_dithering_matrix[3]=1;
   }
}
