/************************************************************************************
*                                                                             	    *
*   lcd_process.c     : contains switch case on the received messages            	*
*						in LCD mailbox												*
*																					*
*	Project			: BLUETOOTH														*
*		                                            					    		*
*   Author         	: Davide Carpegna 				    							*
*   Version number	: 1.0														    *
*   Date        	: 29 September 2000												*		
*																				    *
*   (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved		*		
*************************************************************************************/

#include "rvf/rvf_api.h"
#include "rv/rv_general.h"
#include "r2d/lcd_messages.h"
#include "rvm/rvm_use_id_list.h"


void lcd_process(T_RV_HDR * msg_ptr)
{  

	switch (msg_ptr->msg_id)
	{
 
  		case LCD_INIT_EVT:	
   			/* LCD_init request by appli/atp */
   			{
   				rvf_send_trace("received LCD_init   ",20, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				LCD_Init_ll();		
   					
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_CLEAR_EVT:	
   			/* clear_lcd request by appli/atp */
   			{
   				rvf_send_trace("received lcd_clear  ",20, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				LCD_Clear_ll();		
   						
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};
		
   		case LCD_WRITE_STRING_EVT:	
   			/* write string request by appli/atp */
   			{
   				rvf_send_trace("received write string   ",24, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				LCD_Write_String((((T_LCD_WRITE_STRING *) msg_ptr)->row),(((T_LCD_WRITE_STRING *) msg_ptr)->column),&(((T_LCD_WRITE_STRING *) msg_ptr)->string),(((T_LCD_WRITE_STRING *) msg_ptr)->mode));
   						
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_WRITE_CENTER_EVT:	
   			/* write_string_center request by appli/atp */
   			{
   				rvf_send_trace("received write_string_center   ",31, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				LCD_Write_Center(&(((T_LCD_WRITE_CENTER *) msg_ptr)->string));
   						
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_CLEAR_STRING_EVT:	
   			/* clear_string request by appli/atp */
   			{
   				
   				rvf_send_trace("received clear string   ",24, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Clear_String((((T_LCD_CLEAR_STRING *) msg_ptr)->row));
   								
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_CLEAR_WORD_EVT:	
   			/* clear_word request by appli/atp */
   			{
   				rvf_send_trace("received clear word   ",22, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Clear_Word((((T_LCD_CLEAR_WORD *) msg_ptr)->row),(((T_LCD_CLEAR_WORD *) msg_ptr)->column),(((T_LCD_CLEAR_WORD *) msg_ptr)->length));
   						
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_PUT_PIXEL_EVT:	
   			/* put_pixel request by appli/atp */
   			{
   				rvf_send_trace("received put pixel   ",21, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Put_Pixel((((T_LCD_PUT_PIXEL *) msg_ptr)->x),(((T_LCD_PUT_PIXEL *) msg_ptr)->y));
   												

   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_CLEAR_PIXEL_EVT:	
   			/* clear_pixel request by appli/atp */
   			{
   				rvf_send_trace("received clear pixel   ",23, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Clear_Pixel((((T_LCD_CLEAR_PIXEL *) msg_ptr)->x),(((T_LCD_CLEAR_PIXEL *) msg_ptr)->y));
   												
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_DRAW_LINE_EVT:	
   			/* draw_line request by appli/atp */
   			{
   				rvf_send_trace("received draw line   ",21, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Draw_Line((((T_LCD_DRAW_LINE *) msg_ptr)->x1),(((T_LCD_DRAW_LINE *) msg_ptr)->y1),(((T_LCD_DRAW_LINE *) msg_ptr)->x2),(((T_LCD_DRAW_LINE *) msg_ptr)->y2));
   							
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};
   		
   		case LCD_CLEAR_LINE_EVT:	
   			/* clear_line request by appli/atp */
   			{
   				rvf_send_trace("received clear line   ",22, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Clear_Line((((T_LCD_CLEAR_LINE *) msg_ptr)->x1),(((T_LCD_CLEAR_LINE *) msg_ptr)->y1),(((T_LCD_CLEAR_LINE *) msg_ptr)->x2),(((T_LCD_CLEAR_LINE *) msg_ptr)->y2));
   							
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_DRAW_RECTANGLE_EVT:	
   			/* draw_rectangle request by appli/atp */
   			{
   				rvf_send_trace("received draw rectangle   ",26, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Draw_Rectangle((((T_LCD_DRAW_RECTANGLE *) msg_ptr)->x1),(((T_LCD_DRAW_RECTANGLE *) msg_ptr)->y1),(((T_LCD_DRAW_RECTANGLE *) msg_ptr)->x2),(((T_LCD_DRAW_RECTANGLE *) msg_ptr)->y2));
   												
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_CLEAR_RECTANGLE_EVT:	
   			/* clear_rectangle request by appli/atp */
   			{
   				rvf_send_trace("received clear rectangle   ",27, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Clear_Rectangle((((T_LCD_CLEAR_RECTANGLE *) msg_ptr)->x1),(((T_LCD_CLEAR_RECTANGLE *) msg_ptr)->y1),(((T_LCD_CLEAR_RECTANGLE *) msg_ptr)->x2),(((T_LCD_CLEAR_RECTANGLE *) msg_ptr)->y2));
   												
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};

   		case LCD_DRAW_ICON_EVT:	
   			/* display icon request by appli/atp */
   			{
   				rvf_send_trace("received display icon   ",24, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				//LCD_Draw_Icon((((T_LCD_DRAW_ICON *) msg_ptr)->x),(((T_LCD_DRAW_ICON *) msg_ptr)->y),(((T_LCD_DRAW_ICON *) msg_ptr)->icon_id));
   						
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};
   			
   		case LCD_DRAW_BLOC_EVT:	
   			/* draw bloc request by appli/atp */
   			{
   				rvf_send_trace("received draw bloc  ",20, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
  				//LCD_PixBlt_ll((((T_LCD_DRAW_BLOC *) msg_ptr)->table),(((T_LCD_DRAW_BLOC *) msg_ptr)->x_dim),(((T_LCD_DRAW_BLOC *) msg_ptr)->y_dim),(((T_LCD_DRAW_BLOC *) msg_ptr)->x_pos),(((T_LCD_DRAW_BLOC *) msg_ptr)->y_pos));
   												
   				/* free memory used for the DRIVER message */
   				rvf_free_buf((((T_LCD_DRAW_BLOC *) msg_ptr)->table));		
   				/* free memory used for the table copy */
   				rvf_free_buf ((void *) msg_ptr);
   				rvf_send_trace("free      ",10,NULL_PARAM , RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				break;
   			};

   		case LCD_REFRESH_BLOC_EVT:	
   			/*refresh bloc request by appli/atp */
   			{
   				rvf_send_trace("received refresh bloc",21, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Refresh_Bloc((((T_LCD_REFRESH_BLOC *) msg_ptr)->table),(((T_LCD_REFRESH_BLOC *) msg_ptr)->x_dim),(((T_LCD_REFRESH_BLOC *) msg_ptr)->y_dim),(((T_LCD_REFRESH_BLOC *) msg_ptr)->x_pos),(((T_LCD_REFRESH_BLOC *) msg_ptr)->y_pos));
   				
   				/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   				
   			};

		case LCD_SET_POWER_EVT:	
   			/* set_power request by appli/atp */
   			{
   				rvf_send_trace("received set power  ",20, NULL_PARAM, 
   				RV_TRACE_LEVEL_DEBUG_LOW, R2D_USE_ID );
   				
   				//LCD_Set_Power_ll();
   												
   					/* free memory used for the DRIVER message */
   				rvf_free_buf ((void *) msg_ptr);
   				break;
   			};


	}


}






