/****************************************************************************/
/*                                                                          */
/*	File Name:	lcd_messages.h												*/
/*                                                                          */
/*	Purpose:	This file contains data structures and functions prototypes */
/*				used to send events to the LCD SWE.							*/
/*                                                                          */
/*  Version		0.1															*/
/*																			*/
/* 	Date       	Modification												*/
/*  ------------------------------------									*/
/*  29/09/2000	Create														*/
/*																			*/
/*	Author		Davide Carpegna												*/
/*																			*/
/* (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved*/
/****************************************************************************/
#ifndef __LCD_MESSAGES_H_
#define __LCD_MESSAGES_H_

#include "r2d/lcd_functions.h"

#ifdef __cplusplus
extern "C"
{
#endif


/* the message offset must differ for each SWE in order to have unique msg_id in the system */
#define LCD_MESSAGES_OFFSET		(0x34 << 10)


#define LCD_INIT_EVT					1	
#define LCD_CLEAR_EVT					2
#define LCD_WRITE_STRING_EVT			3
#define LCD_WRITE_CENTER_EVT			4			
#define LCD_CLEAR_STRING_EVT			5
#define LCD_CLEAR_WORD_EVT				6
#define LCD_PUT_PIXEL_EVT				7
#define LCD_CLEAR_PIXEL_EVT				8
#define LCD_DRAW_LINE_EVT				9
#define LCD_DRAW_RECTANGLE_EVT			10
#define LCD_CLEAR_LINE_EVT				11
#define LCD_CLEAR_RECTANGLE_EVT			12
#define LCD_DRAW_ICON_EVT				13
#define LCD_DRAW_BLOC_EVT				14
#define LCD_REFRESH_BLOC_EVT			15
#define LCD_SET_POWER_EVT				16	


/* structures of messages send to LCD	*/


/******* LCD INIT **********/

typedef struct
{
	T_RV_HDR os_hdr;
	UINT8 empty;
	
} T_LCD_INIT;

/******* LCD CLEAR **********/

typedef struct
{
	T_RV_HDR os_hdr;
	UINT8 empty;
	
} T_LCD_CLEAR;

/******* WRITE STRING **********/

typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					row;
	UINT8					column;
	T_VIDEO_MODE			mode;
	char					string;

} T_LCD_WRITE_STRING;

/******* WRITE STRING CENTER**********/

typedef struct
{
	T_RV_HDR				os_hdr;
	char					string;
	
} T_LCD_WRITE_CENTER;

/******* CLEAR STRING **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					row;
	
} T_LCD_CLEAR_STRING;

/******* CLEAR WORD **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					row;
	UINT8					column;
	UINT16					length;	
	
} T_LCD_CLEAR_WORD;

/******* PUT PIXEL **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					x;
	UINT8					y;
	
	
} T_LCD_PUT_PIXEL;

/******* CLEAR PIXEL **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					x;
	UINT8					y;
		
} T_LCD_CLEAR_PIXEL;

/******* DRAW LINE **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					x1;
	UINT8					y1;
	UINT8					x2;
	UINT8					y2;
	
} T_LCD_DRAW_LINE;

/******* DRAW RECTANGLE **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					x1;
	UINT8					y1;
	UINT8					x2;
	UINT8					y2;
	
} T_LCD_DRAW_RECTANGLE;


/******* CLEAR LINE **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					x1;
	UINT8					y1;
	UINT8					x2;
	UINT8					y2;
	
} T_LCD_CLEAR_LINE;

/******* CLEAR RECTANGLE **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					x1;
	UINT8					y1;
	UINT8					x2;
	UINT8					y2;
	
} T_LCD_CLEAR_RECTANGLE;

/******* DRAW ICON **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	UINT8					icon_id;
	UINT8					x;
	UINT8					y;
	
} T_LCD_DRAW_ICON;

/******* DRAW BLOC **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	char					*table;
	UINT8					x_dim;
	UINT8					y_dim;
	UINT8					x_pos;
	UINT8					y_pos;
	
} T_LCD_DRAW_BLOC;

/******* REFRESH BLOC **********/
typedef struct
{
	T_RV_HDR				os_hdr;
	char					*table;
	UINT8					x_dim;
	UINT8					y_dim;
	UINT8					x_pos;
	UINT8					y_pos;
} T_LCD_REFRESH_BLOC;

/******* SET POWER  **********/
typedef struct
{
	T_RV_HDR				os_hdr;

} T_LCD_SET_POWER;

/******    function prototypes    ********/

T_RV_RET lcd_reset(void);
T_RV_RET lcd_clear(void);
T_RV_RET lcd_init(void);
T_RV_RET lcd_write_string(UINT8 row, UINT8 column, char *string,T_VIDEO_MODE mode);
T_RV_RET lcd_write_center( char *string);
T_RV_RET lcd_clear_string(UINT8 row);
T_RV_RET lcd_clear_word(UINT8 row, UINT8 column, UINT16 length);
T_RV_RET lcd_put_pixel(UINT8 x, UINT8 y);
T_RV_RET lcd_clear_pixel(UINT8 x, UINT8 y);
T_RV_RET lcd_draw_line(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2);
T_RV_RET lcd_clear_line(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2);
T_RV_RET lcd_draw_rectangle(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2);
T_RV_RET lcd_clear_rectangle(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2);
T_RV_RET lcd_draw_icon(UINT8 x,UINT8 y,UINT8 icon_id);
T_RV_RET lcd_refresh_bloc(char *table,UINT8 x_dim,UINT8 y_dim,UINT8 x_pos,UINT8 y_pos);
T_RV_RET lcd_pix_blt(int x_pos,int y_pos,int x_dim,int y_dim,char *table);
T_RV_RET lcd_enable(UINT8 x);
T_RV_RET lcd_set_power();
T_RV_RET lcd_cursor(UINT8 y,UINT8 x);


#ifdef __cplusplus
}
#endif


#endif /* __LCD_MESSAGES_H_ */

