/****************************************************************************/
/*                                                                          */
/*	File Name:	lcd_gsm_ps_api.c												*/
/*                                                                          */
/*	Purpose:	This file contains the adaptation layer used to direct		*/
/*	Condat LCD calls to void or not											*/
/*                                                                          */
/*  Version		0.1															*/
/*																			*/
/* 	Date       	Modification												*/
/*  ------------------------------------									*/
/*  29/09/2000	Create														*/
/*																			*/
/*	Author		Davide Carpegna												*/
/*																			*/
/* (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved*/
/****************************************************************************/

#ifndef _WINDOWS
#include "config/rv.cfg"
#endif


#if (_GSM==1)
#include "rv/rv_general.h"
#include "rvf/rvf_api.h"
#include "r2d/lcd_messages.h"


T_RV_RET LCD_Reset(void)
{
#if (TEST==0)
	return lcd_reset();
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_Clear(void)
{
#if (TEST==0)
	return lcd_clear();
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_Init(void)
{
#if (TEST==0)
	return lcd_init();
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_WriteString(UINT8 row, UINT8 column, char *string, T_VIDEO_MODE mode)
{
#if (TEST==0)
	return lcd_write_string(row, column, string, mode);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_WriteCenter( char *string)
{
#if (TEST==0)
	return lcd_write_center(string);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_ClearString(UINT8 row)
{
#if (TEST==0)
	return lcd_clear_string(row);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_ClearWord(UINT8 row, UINT8 column, UINT16 length)
{
#if (TEST==0)
	return lcd_clear_word(row, column, length);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_PutPixel(UINT8 x, UINT8 y)
{
#if (TEST==0)
	return lcd_put_pixel(x, y);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_ClearPixel(UINT8 x, UINT8 y)
{
#if (TEST==0)
	return lcd_clear_pixel(x, y);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_DrawLine(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2)
{
#if (TEST==0)
	return lcd_draw_line(x1, y1, x2, y2);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_ClearLine(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2)
{
#if (TEST==0)
	return lcd_clear_line(x1, y1, x2, y2);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_DrawRectangle(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2)
{
#if (TEST==0)
	return lcd_draw_rectangle(x1, y1, x2, y2);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_ClearRectangle(UINT8 x1, UINT8 y1, UINT8 x2, UINT8 y2)
{
#if (TEST==0)
	return lcd_clear_rectangle(x1, y1, x2, y2);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_DrawIcon(UINT8 x,UINT8 y,UINT8 icon_id)
{
#if (TEST==0)
	return lcd_draw_icon(x,y,icon_id);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_RefreshBloc(char *table,UINT8 x_dim,UINT8 y_dim,UINT8 x_pos,UINT8 y_pos)
{
#if (TEST==0)
	return lcd_refresh_bloc(table,x_dim,y_dim,x_pos,y_pos);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_PixBlt(int x_pos,int y_pos,int x_dim,int y_dim,char *table)
{
#if (TEST==0)
	return lcd_pix_blt(x_pos,y_pos,x_dim,y_dim,table);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_Enable(UINT8 x)
{
#if (TEST==0)
	return lcd_enable(x);
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_SetPower(void)
{
#if (TEST==0)
	return lcd_set_power();
#else
	return RV_OK;
#endif
}


T_RV_RET LCD_Cursor(UINT8 y,UINT8 x)
{
#if (TEST==0)
	return lcd_cursor(y,x);
#else
	return RV_OK;
#endif
}


#endif
