/************************************************************************************
* lcd_functions.h :            contains low level function for the lcd				*
*																					*	
*																					*
*	Author: Davide Carpegna															*
*																					*
*	version: 1.0																	*
*																					*
*	Date: 13/11/2000																*
*   (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved		*
*                                                                                   *
* --------------------------------------------------------------------------------- *
*                                                                                   *
*   History:                                                                        *
*                                                                                   *
*   10/18/2001 - Updated for R2D by Christophe Favergeon		                    * 
*                                                                                   *		
************************************************************************************/
#ifndef __LCD_FUNCTIONS_H_
#define __LCD_FUNCTIONS_H_

#include "rv/rv_general.h"
#include "rvf/rvf_api.h"
#include "rv/general.h"
#include "r2d/uwire.h" 
#include "r2d/r2d_config.h"

/**********     VIDEO MODE definition     *********/

typedef enum {
				NORMAL, 
				INVERSE
			}T_VIDEO_MODE;

//LCD physical configuration:
//LCD_MODE->1 reversed LCD (origin in the bottom right corner)
//LCD_MODE->0 normal positioned LCD (origin in the top left corner)
#ifndef _WINDOWS
	#define LCD_MODE				1
#else
	#define LCD_MODE				0
#endif

/* display dimensions. */
#define DISP_PIXELWIDTH      R2D_WIDTH
#define DISP_PIXELHEIGHT     R2D_HEIGHT
#define DISP_PAGEHEIGHT      (R2D_HEIGHT >> 3)

//display center 	
#define X_CENTER			(R2D_WIDTH>>1)
#define Y_CENTER			((DISP_PAGEHEIGHT>>1)-1)

//functions prototype
void LCD_Clear_ll (void);
void LCD_Init_ll(void);
void LCD_Write_String(UINT8 row, UINT8 column, char *string, T_VIDEO_MODE mode);
void LCD_Write_Center( char *string);

/******* ICONS DEFINITION **********/

#define LCD_BATTERY_ICON_0  (0)        
#define LCD_BATTERY_ICON_1  (1)    
#define LCD_BATTERY_ICON_2  (2)    
#define LCD_BATTERY_ICON_3  (3)    
#define LCD_BATTERY_ICON_4  (4)
#define LCD_ENVELOP_ICON    (5)
#define LCD_RECORD_ICON     (6)
#define LCD_ONLINE_ICON     (7)
#define LCD_ANTENNA_ICON_0  (8)
#define LCD_ANTENNA_ICON_1  (9)
#define LCD_ANTENNA_ICON_2  (10)
#define LCD_ANTENNA_ICON_3  (11)
#define LCD_ANTENNA_ICON_4  (12)
#define LCD_CLEAR_ICON      (13)



#endif /*__LCD_FUNCTIONS_H_*/
