/************************************************************************************
* uwire.c :            contains driver for the uwire HD module						*
*																					*	
*																					*
*	Author: Davide Carpegna															*
*																					*
*	version: 1.0																	*
*																					*
*	Date: 22/09/2000																*
*   (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved		*		
************************************************************************************/

#include "rv/general.h"
#include "r2d/uwire.h" 
#include "rvf/rvf_api.h"

/********************************************************************/
/*	set the DC input to low for command transmission				*/
/*																	*/
/********************************************************************/
void set_DC_low(void)
{
	* (volatile UINT16 *) GPIO_OUT &= ~(0x02); //gpio(1) ->0
}

/********************************************************************/
/*	set the DC input to high for data transmission	 				*/
/*																	*/
/********************************************************************/
void set_DC_high(void)
{
	* (volatile UINT16 *) GPIO_OUT |= 0x02; //gpio(1) ->1
}

/********************************************************************/
/*	transmit commands to the lcd		    		 				*/
/*																	*/
/********************************************************************/
void lcd_transmit_cmd(UINT8 cmd)
{
	set_DC_low();
	* (volatile UINT16 *) TDR = cmd <<8;
	* (volatile UINT16 *) CSR |= NB_BITS_WR_8 + CS_CMD + START ; // transmit command data
	while (((* (volatile UINT16 *) CSR) & CSRB) != 0 ); // wait for end of WRITE
	* (volatile UINT16 *) CSR &= ~CS_CMD; // clears Chip Select 	
}

/********************************************************************/
/*	transmit data to the lcd			    		 				*/
/*																	*/
/********************************************************************/
void lcd_transmit_data(UINT8 data)
{
	set_DC_high();
	* (volatile  UINT16 *) TDR = data <<8;
	* (volatile UINT16 *) CSR |= NB_BITS_WR_8 + CS_CMD + START ; // transmit data
		//while (((* (volatile UINT16 *) CSR) & CSRB) != 0 ); // wait for end of WRITE
	//* (volatile UINT16 *) CSR &= ~CS_CMD; // clears Chip Select 	
}

extern BOOLEAN lcd_polling(void)
{
	if (((* (volatile UINT16 *) CSR) & CSRB) == 0 )
	{
	    * (volatile UINT16 *) CSR &= ~CS_CMD; // clears Chip Select 
		return(TRUE);
	}
	else 
		return(FALSE);
}

/********************************************************************/
/*	initialize the uwire parameters for the lcd		    			*/
/*																	*/
/********************************************************************/
void uwire_init_lcd()
{
	* ( UINT16 *) GPIO_INOUT &= ~(0x0002); // configures gpio(1) in output mode
	
	* ( UINT16 *) CNTL_RST &= ~(0x04); // releases reset_out
	* ( UINT16 *) CNTL_RST |= (0x04); // set reset_out to 0
	rvf_delay(RVF_MS_TO_TICKS(1));    // waits for 5 ms
	* ( UINT16 *) CNTL_RST &= ~(0x04); // releases reset_out

	
	* (volatile UINT16 *) SR1 = CS1_FRQ_FINT_4 ; // F_INT/4 -> 13M/4 = 3.25 Mhz   
	* (volatile UINT16 *) SR3 = SR3_CLK_EN; // enables the uwire clock
	* (volatile UINT16 *) CSR = INDEX_CS1; // selects CS1
}



