/******************************************************************************
 * Power Task (pwr)
 * Design and coding by Svend Kristian Lindholm, skl@ti.com
 *
 * PWR ETM interface
 *
 * $Id: pwr_tm_i.h 1.1 Wed, 20 Aug 2003 10:22:37 +0200 skl $
 *
 ******************************************************************************/

#ifndef _LCC_TM_I_H_
#define _LCC_TM_I_H_

#define PWR_CFG_ID_SIZE      2
#define PWR_COMMON_CFG_SIZE 14
#define PWR_BAT_CFG_SIZE    36
#define PWR_TEMP_CFG_SIZE   72
#define PWR_MMI_CFG_SIZE     2
#define PWR_CHG_CFG_SIZE     8
#define PWR_I2V_CAL_SIZE     6
#define PWR_VBAT_CAL_SIZE    6
#define PWR_DYNAMIC_SIZE     1
#define PWR_TMASK_SIZE       4

// This enumeration should be shared with the PC test mode side
enum {
    PWR_CFG_ID = 0,
    PWR_COMMON,
    PWR_CHG,
    PWR_BAT,
    PWR_TEMP,
    PWR_MMI,
    PWR_I2V_CAL = 10,
    PWR_VBAT_CAL,
    PWR_MMI_TEST = 15,
    PWR_DYNAMIC = 20,
    PWR_TRACE_MASK= 21
} ;

// Test mode indication mail sent to ETM
// NOTE: Also used as request mail
struct etm_tm_ind_s {
     T_RV_HDR header;
     uint8 size;
     uint8 status;
     uint8 data[127];
};

typedef struct etm_tm_ind_s    T_ETM_TM_IND; // Use same buffer in both directions

#endif //_LCC_TM_I_H_
