/******************************************************************************
 * Power Task (pwr)
 * Design and coding by Svend Kristian Lindholm, skl@ti.com
 *
 * PWR Configuration Variables NOT in FFS
 *
 * $Id: pwr_cfg_i.h 1.2 Wed, 20 Aug 2003 12:54:50 +0200 skl $
 *
 ******************************************************************************/

#ifndef _LCC_CFG_I_H_
#define _LCC_CFG_I_H_


// The charging current used in SW precharge state
#define ICHG_PRECHG  500

// The SW precharge start threshold - discriminator that decides between entering INI or PRE states
#define VBAT_PRECHG_START 3200

// The SW precharge stop threshold - PRE->INI state & FFS configuration files will be read
#define VBAT_PRECHG_STOP  3600

// Define how many consecutive charger unplugs we must detect in order to have a 'real' unplug
#define CONSECUTIVE_CHG_UNPLUGS 5

// Define the size of the exponential avg window when in PRE state (i.e. no FFS configuration is read)
#define PRECHG_AVG_WINDOW_SIZE  5

// Define the battery slip number before we read the battery id
#define BATTERY_TYPE_SLIP 4

// Define the charger slip number before we read the charger id
#define CHARGER_TYPE_SLIP 2

// Define the lower charger id out-of-bound value (mV)
#define CHARGER_TYPE_OUT_OF_BOUND_LOW 4000

// Define the 'typical' charger id that will be used if the charger id reading has failed
// Make sure it's in the charger voltage interval
#define CHARGER_TYPE_TYPICAL          4201

// The Q402 Vchg thresholds that decides a charger unplug when charging has been initiated
#define VCHG_Q402_THR  1000
#define ICHG_Q402_THR  20


#endif