/******************************************************************************
 * Power Task (pwr)
 * Design and coding by Svend Kristian Lindholm, skl@ti.com
 *
 * PWR MMI Interface
 *
 * $Id: pwr_api.c 1.1 Wed, 20 Aug 2003 10:22:37 +0200 skl $
 *
 ******************************************************************************/

#include "lcc/lcc.h"
#include "lcc/lcc_env.h"
#include "lcc/lcc_trace.h"
#include "rv/rv_defined_swe.h"

/******************************************************************************
 * Function prototypes
 ******************************************************************************/

T_RVM_RETURN pwr_start_timer(UINT32 *timer_begin);

// Inform the PWR process which callback function to send MMI events
// and perform initialization of mmi related variables
void pwr_register (T_RV_RETURN_PATH *return_path, void *ptr) {
    ttw(ttr(TTrInit,"pwr_register  (%d)" NL, 0x00));

    // Assign return path (callback or task address id)
    pwr_ctrl->rpath.callback_func = return_path->callback_func;
    pwr_ctrl->rpath.addr_id       = return_path->addr_id;

    // Pointer to mmi event memory allocated (& deallocated) by the MMI
    pwr_ctrl->mmi_ptr = (struct mmi_info_ind_s *) ptr;

    // Yes - the mmi has registered!
    pwr_ctrl->flag_mmi_registered = 1;

    // Start the mmi repetition timer
    pwr_start_timer(&pwr_ctrl->time_begin_mmi_rep);
    ttw(ttr(TTrTimerLow,"mmi repetition timer started(%d)" NL, 0));

    ttw(ttr(TTrInit,"pwr_register  (%d)" NL, 0xFF));
}
