/******************************************************************************
 * Flash File System (ffs)
 * Idea, design and coding by Mads Meisner-Jensen, mmj@ti.com
 *
 * ffs test data
 *
 * $Id: tdata.h 1.4 Mon, 08 Apr 2002 10:02:52 +0200 tsj $
 *
 ******************************************************************************/

#define TEST_DATA_NUM 11


/******************************************************************************
 * Global Macros
 ******************************************************************************/

#define TDATA(index) (char *) tdata[index], sdata[index]

// Make <addr, size> arguments with a string
#define TDATA_STRING(string) (char *) string, strlen(string)

// This is guaranteed to be at least the size of fs.filesize_max 
// NOTEME: not any more
#define TDATA_HUGE (TEST_DATA_NUM - 1)

// This is to use while testing in target
#define TDATA_BIG  3

// This is guaranteed to be at most four bytes
#define TDATA_TINY (0)


/******************************************************************************
 * Globals and Prototypes
 ******************************************************************************/

extern char *tdata[TEST_DATA_NUM];
extern int sdata[TEST_DATA_NUM];


int test_tdata_init(void);
