/******************************************************************************
 * Flash File System (ffs)
 * Idea, design and coding by Mads Meisner-Jensen, mmj@ti.com
 *
 * ffs test data
 *
 * $Id: tdata.c 1.9 Tue, 14 Oct 2003 12:50:00 +0200 tsj $
 *
 ******************************************************************************/

#ifndef TARGET
#include "ffs.cfg"
#endif

#if (TARGET == 1)
#include "chipset.cfg"
#endif

#include "ffs/ffs.h"
#include "ffs/board/drv.h"
#include "ffs/board/tdata.h"

#if (TARGET == 0)
#ifdef WIN32
#include "windows.h"
#else //WIN32
#include "sys/mman.h"
#include "unistd.h"
#endif //WIN32

#include <string.h>
#include <stdlib.h>
#include "stdio.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "fcntl.h"
#endif //TARGET == 0

/******************************************************************************
 * Globals
 ******************************************************************************/

// Buffer for tdata 'HUGE'. In target it point to the flash device, on the
// PC a buffer is allocated and filled with data from a c code file.
char *tdata_buf;

int sdata[TEST_DATA_NUM];

// Initialize test data. 
int test_tdata_init(void)
{
    int i, error, tdatasize, fsize = 60 * 1024;  // Check the file size or?

#ifdef WIN32
    DWORD nbytesread;
	OFSTRUCT lpReOpenBuff;
    HANDLE fd;
    char *fname = "../core.c"; // file to use as test data
#else
    char *fname = "core.c";
    int fd;
#endif
    // Set the size to the maximum image size
    tdatasize = 8 * 1024 * 1024;

    // Open file NOTEME change to readonly
#if (TARGET == 0)    
#ifdef WIN32
    fd = OpenFile(fname, &lpReOpenBuff, OF_READ);
#else 
    fd = open(fname, O_RDONLY, S_IRWXU|S_IRWXG|S_IRWXO);
#endif //WIN32
    if (fd == -1) {
        perror("Failed to open flash image"); exit(1);
    }

    if ((tdata_buf = (char*) malloc(tdatasize)) == 0)
        return EFFS_MEMORY;

#ifdef WIN32
    error = ReadFile(fd, tdata_buf, fsize, &nbytesread, 0);
#else
    error = read(fd, tdata_buf, fsize);
#endif
    if (error < 0) {
        perror("Failed to read file"); exit(1);
    }

#ifdef WIN32
    error = CloseHandle(fd);
#else
    error = close(fd);
#endif
    if (error < 0) {
        perror("Failed to close file"); exit(1);
    }

    // Fill the rest of tdata_buf
    for (i = 1; i < tdatasize/fsize; i++)
        memcpy(&tdata_buf[i], &tdata_buf[0], fsize);
#endif

#if (TARGET == 0)
    // Init tdata
    tdata[TDATA_HUGE] = tdata_buf;
#else
#if (CHIPSET == 12) // Calypso+. Do not read from the secure rom
    tdata[TDATA_HUGE] = (char *) 0x4000000;
#else
    tdata[TDATA_HUGE] = (char *) 0x1;
#endif
#endif //TARGET == 0

    for (i = 0; i < TEST_DATA_NUM; i++) 
        sdata[i] = strlen(tdata[i]);
    
    return EFFS_OK;
}

char *tdata[TEST_DATA_NUM] =
{
    // 0
    "yo",

    // 1
    "NineBytes",

    // 2
    "EighteenCharacters",

    // 3
    "The quick brown fox jumped over the little lazy rabbit then it turned "
    "around and ate the little stupid bunny."
    "The brown fox ate too much and became sick.",

    // 4
    "Foo bar fum fi fo, look high, look low, where it is, i don't know",

    // 5
    "55555",

    // 6
    "Two Canadian guys, Mike and Rob were on the roof, laying tile,"
    "when a sudden gust of wind came and knocked down their ladder." 
    "'I have an idea,' said Mike. 'We'll throw you down, and then"
    "you can pick up the ladder.'" 
    "What, do you think I'm stupid? I have an idea. I'll shine my"
    "flashlight, and you can climb down on the beam of light." 
    "What, do you think I'm stupid? You'll just turn off the"
    "flashlight when I'm halfway there.''",

    // 7
    "7777777",

    // 8
    "88888888",

    // 9
    "999999999",

    // 10
    "dummy"
};



