#!/usr/bin/perl -w

if ($#ARGV < 0) { die "Must give argument 'c' or 'pl'"; }

$c = ($ARGV[0] eq "c");
shift;

$c && c_begin();
!$c && pl_begin();

while (<>) {
    chop;
    if (/^\s*(EFFS_\w+)\s*=\s*(-?[0-9]+),\s*\/\* (.*) \*\//) {
	$name = $1;
	$code = $2;
	$text = $3;
	$c  && print "    case $name: return \"$text\"; /* $code */\n";
	!$c && print "\$$name = $code;\n";
	!$c && print "\$FFS_ERRORSTR{$code} = \"$text\";\n";
    }
}

$c && c_end();
!$c && pl_end();


sub c_begin
{
    print "/* This file is autogenerated --- do not edit. */\n\n";
    
    print "#include \"ffs/ffs.h\"\n\n";
    
    print "char *ffs_strerror(effs_t error)\n";
    print "{\n";
    print "    switch (error) {\n";
}

sub c_end
{
    print "    default: return \"unknown ffs error code!\";\n";
    print "    }\n";
    print "}\n";
}

sub pl_begin
{
    print "# This file is autogenerated --- do not edit.\n\n";
}

sub pl_end
{
}

