/******************************************************************************
 * Flash File System (ffs)
 * Idea, design and coding by Mads Meisner-Jensen, mmj@ti.com
 *
 * FFS configuration
 *
 * $Id: cfgffs.c 1.27 Fri, 19 Dec 2003 12:00:13 +0100 tsj $
 *
 ******************************************************************************/

#ifndef TARGET
#include "ffs.cfg"
#endif

#include "ffs/ffs.h"
#include "ffs/board/drv.h"

#include "config/board.cfg"

#if (BOARD == 34)
  #include "ffs/board/ffspcm.h"
#endif

#include "config/rf.cfg"

#include <string.h>

/******************************************************************************
 * Flash Device Configuration
 ******************************************************************************/

#if (TARGET == 1)

// The absolutely easiest way to disable FFS altogether is to set
// ffs_flash_manufact = 0x99 and ffs_flash_device = 0x9999. Because this is
// (as of today at least) an undefined device, FFS will NOT initialize and
// every FFS function call will fail (with no side-effects).

// FFS will automatically detect the flash device if both ffs_flash_manufact
// and ffs_flash_device are zero. Note that this works *only* if the flash
// device is mapped at address zero. Otherwise you *have* to supply
// manufacturer and device IDs.

// FFS can be configured to run in ram only. In this case the
// 'ffs_flash_manufact' must be set to MANUFACT_RAM and an address to a
// static user allocated ram buffer must be applied to the variable
// 'ffs_flash_address'. In a ram configuration the 'ffs_flash_device' is an
// arbitrary value that must be in sync with the 'device code' value chosen
// in dev.c.

#if (BOARD == 34)
uint16 ffs_flash_manufact = MANUFACT_RAM;
uint16 ffs_flash_device   = 0x0404; // RAM

int ffs_ram_image_address = FFS_BASE_ADDRESS;

#else

uint16 ffs_flash_manufact = 0x00; // autodetect device
//uint16 ffs_flash_manufact = MANUFACT_RAM;
//uint16 ffs_flash_manufact = 0x04; // Fujitsu
//uint16 ffs_flash_manufact = 0xBF; // SST

uint16 ffs_flash_device   = 0x0000; // autodetect device
//uint16 ffs_flash_device     = 0x0404; // RAM
//uint16 ffs_flash_device   = 0xB496; // Fujitsu stacked device
//uint16 ffs_flash_device   = 0x2761; // SST device 1601
//uint16 ffs_flash_device   = 0x2259; // 8x8kB blocks

int ffs_ram_image_address = 0;  // Dummy

//unsigned char ffs_image[8*8*1024];
//int ffs_ram_image_address = (int) &ffs_image;

#endif // BOARD == 34

#else

uint16 ffs_flash_manufact = 'T';
//uint16 ffs_flash_device   = 0x0F12; // Test device: 128x64kB blocks
uint16 ffs_flash_device   = 0x0F10; // Test device: 16x64kB blocks
//uint16 ffs_flash_device   = 0x080D; // Test device: 8x8kB blocks
//uint16 ffs_flash_device   = 0x0404; // Test device: 4x4kB blocks

int ffs_ram_image_address = 0;  // Dummy
#endif


/******************************************************************************
 * ffs_is_modify_valid()
 ******************************************************************************/

// This is function to be implemented by the application programmer. It is
// called by ffs when a read-only object is about to be modified or
// removed. It should return zero if the operation should be
// disallowed. Returning non-zero means go ahead.
effs_t ffs_is_modifiable(const char *name)
{
    // default is to allow any modification of read-only objects.

    // example of how to disallow modifying a specific object...
    if (strcmp("IMEI", &name[strlen(name) - 4]) == 0)
        return 0;

    return 1;
}
