/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */

var runtime = java.lang.Runtime.getRuntime();

/**
 * Print some memory statics info.
 */
public function printMemStats()
{
  java.lang.System.gc();
  
  var freeMem  = (runtime.freeMemory())/(1024*1024);
  var totalMem = (runtime.totalMemory())/(1024*1024);
  
  pkg.output.writeln( "  free memory: " + freeMem + "M" );
  pkg.output.writeln( "+ used memory: " + (totalMem-freeMem) +"M" );
  pkg.output.writeln( " --------------------------" );
  pkg.output.writeln( " total memory: " + totalMem +"M" );
}




/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
