/*=============================================================================
 *     Copyright Texas Instruments, Inc., 2004.  All Rights Reserved.
 */

/**
 * A timer that will interrupt the current thread after the specified number
 * of milliseconds elapse.  The timer begins when you call {@link #start}.
 * For example:
 * <pre>
 *   var watchdog = new pkg.util.WatchdogTimer(5000);  // 5 sec timer
 *   try
 *   {
 *     watchdog.start();
 *     ... do stuff ...
 *   }
 *   catch(java.lang.InterruptedException e)
 *   {
 *     ... timeout occurred ...
 *   }
 *   finally
 *   {
 *     watchdog.stop();
 *   }
 * 
 * @param ms   the number of milliseconds before the watchdog expires
 */
public function WatchdogTimer(ms)
{
  private var thread = java.lang.Thread.currentThread();
  
  private var timer = new javax.swing.Timer( ms, function(evt) {
    stop();
    thread.interrupt();
  } );
  
  /**
   * Start the timer
   */
  public function start()
  {
    timer.start();
  }
  
  /**
   * Stop (cancel) the timer
   */
  public function stop()
  {
    timer.stop();
  }
  
  /**
   * Stop and restart the timer with the original duration.
   */
  public function restart()
  {
    timer.restart();
  }
}
