/*=============================================================================
 *     Copyright Texas Instruments, Inc., 2001.  All Rights Reserved.
 */


/*=============================================================================
 * File Description:
 *   A generic queue object.  The dequeue() method returns null if the
 *   queue is empty.
 *   
 * Suggestions:
 *   could we use a BlockingQueue derived class???
 */


/**
 * Class Constructor.
 */
public function Queue()
{
  // queue:
  var queueHead = null;
  var queueTail = null;
  var numQueued = 0;
  
  function QueueNode()
  {
    public var next;
    public var data;
  }
  
  /**
   * Add a node the the queue.
   * 
   * @param data     the data to add the queue
   */
  public function enqueue( data )
  {
    synchronized(this)
    {
      var node  = new QueueNode();
      node.next = null;
      node.data = data;
      
      if( queueHead == null )
      {
        queueHead = node;
      }
      else
      {
        queueTail.next = node;
      }
      
      queueTail = node;
      numQueued++;
    }
  }
  
  /**
   * Get the next element from the queue.
   * 
   * @return next element, or null if none
   */
  public function dequeue()
  {
    synchronized(this)
    {
      if( queueHead != null )
      {
        numQueued--;
        var data = queueHead.data;
        queueHead = queueHead.next;
        return data;
      }
      else
      {
        return null;
      }
    }
  }
  
  /**
   * Flush the queue.  This discards any elements from the queue.
   */
  public function flush()
  {
    queueHead = null;
    numQueued = 0;
  }
  
  /**
   * Check to see if the queue is empty
   * 
   * @return <code>true</code> if the queue is empty
   */
  public function isEmpty()
  {
    return (queueHead == null);
  }
  
  /**
   * Get the number of items in the queue.
   * 
   * @return the number of items in the queue.
   */
  public function getNumQueued()
  {
    return numQueued;
  }
}



/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */

