/*=============================================================================
 *     Copyright Texas Instruments, Inc., 2003.  All Rights Reserved.
 */

/**
 * Override the talkback service with one that will report errors by calling
 * logError.  This isn't actually a test, but is intended to be run before
 * any Test Harness system test, so that any unhandled exception that happens
 * while the test is running will cause the test to fail.  This isn't intended
 * to be used by regular tests, because we (the developers) would still like
 * to see any talkback report that is generated by a test running in the lab.
 * <p>
 * The original talkback should be restored with <code>RestoreTalkback</code>
 * after the last system tests.
 */
public function OverrideTalkback(args...)
  extends pkg.tf.TestCase("Override Talkback Service")
{
  /**
   * entry point to test
   */
  public function runTest()
  {
    registry.register( new (function() extends ti.chimera.Plugin( main, "Talkback" ) {
      
      /**
       * The custom "talkback" service.
       */
      registerServiceFactory( function() {
        
        return new (function() extends ti.chimera.service.Talkback() {
          
          /**
           * Deal with an unhandled exception.  The thread (<code>t</code>) may
           * be <code>null</code>, for example if the thread the exception is
           * thrown in is AWT event dispatch thread.  
           * 
           * @param t          the thread the exception was thrown in
           * @param e          the exception
           */
          public function uncaughtException( t, e )
          {
            e = unwrapException(e);
            
            var msg = "Uncaught exception in thread: " + ((t == null) ? "AWT" : t) + "\n";
            
            pkg.output.logError(msg);
            pkg.output.logError(e.castToString());
          }
          
          public function reportError(){ /* do nothing */}
          
        })();
        
      } );
      
      /**
       * Sometimes an exception will be wrapped inside another exception.  
       */
      function unwrapException(e)
      {
        /* Unwrap exceptions that might be wrapped in other exceptions...
         */
        while(true)
        {
          if( e instanceof java.lang.reflect.InvokationTargetException )
            e = e.getTargetException();
          else if( e instanceof oscript.exceptions.PackagedScriptObjectException )
            e = e.val;
          else
            return e;
        }
      }
      
    })() );
    
  }
}

