/******************************************************************************
 *     Copyright Texas Instruments 2005. All Rights Reserved.
 */

{

var connections = services["esf connection mgr"].getConnections();

if( connections.hasNext() )
{
  var connection = connections.next();
  
  // in case "start usb" button has not been pressed:
  pkg.util.thif.start( connection.getNodeId() );
  
  // open (non) regression window:
  services["Regression Test"].start();
  
  // load the test cases:
  import "chimera/regression.os";
  
  services["Regression Test"].selectAllTestCases(true);
  services["Regression Test"].startTest( null, true );
}
else
{
  services["prompt"].showErrorMessage("you must connect to the target, in order to run test scripts");
}

}
