/*=============================================================================
 *     Copyright Texas Instruments, Inc., 2003.  All Rights Reserved.
 */

/* This is the top-level that loads all the tests for the test harness itself.
 * The top-level loader file is a bit special in that it doesn't just import
 * other files, and addTestCase()... it actually loads all the test cases
 * multiple times, between ConnectToXYZ and Disconnect steps, so that one run
 * through all the tests will cover both host and target tests.
 */


{
  /**
   * We re-run tests in different modes (hostbuild, usb, etc.)... each test,
   * if it only supports certain modes, can conditionally load based on the
   * value of <code>connection</code>
   * 
   * @param mode   the connection type (string), ie. "hostbuild", "usb", etc.
   */
  function loadAll(mode)
  {
    import "chimera/regression.os";
    import "esf/regression.os";
  }
  
  services["Regression Test"].addTestCase("pkg.tf.ConnectToHost");
  loadAll("hostbuild");
  services["Regression Test"].addTestCase("pkg.tf.Disconnect");
  
  // XXX ConnectToUsb
  // XXX loadAll("usb");
  // XXX Disconnect
  
}
