/******************************************************************************
 *        Copyright Texas Instruments 2003. All Rights Reserved.
 */

/**
 * loopback with wait for cnf
 */
public function loopback(args...)
  extends pkg.tf.TestCase("loopback",null,null,null)
{
  /**
   * The entry point to the test is this method.
   */
  public function runTest()
  {
    
    /* 
     * ATTENTION TEST SCRIPT WIZARD USER:
     * --------- ---- ------ ------ ----
     *   You should implement primitive handler bodies (if any), and
     *   add code to verfy the parameters in received parameters.  The
     *   following methods should be used to indicate test status:
     * 
     *     pkg.output.logInfoMsg(msg)  -  log test status
     *     pkg.output.logError(msg)    -  log failures
     *     pkg.output.logWarning(msg)  -  log marginal passes
     */
    
    // TEST START
    var prim;
    
    prim = new AMD_RX_TASK_START_REQ(
      /* source ehId */          0x0101,
      /* gccOffset */            0,
      /* cfnInit */              0,
      /* cipherCountC */         0,
      /* vocoder */              2,
      /* syncMode */             0
    );
    rctx.sendPrim(prim);
    
    prim = new AMD_TX_TASK_START_REQ(
      /* source ehId */          0x0101,
      /* gccOffset */            0,
      /* vocoder */              2
    );
    rctx.sendPrim(prim);
    
    prim = new AUDIO_PATH_CONTROL_REQ(
      /* source ehId */          0x0101,
      /* deviceId */             ti.th.prim.Audio_DeviceId.RFABB_MONO,
      /* pathControl */          ti.th.prim.Audio_PathControl.ENABLED
    );
    prim = rctx.sendAndWaitForPrim( prim, rctx.type(AUDIO_PATH_CONTROL_CNF) );
    
    // TEST END
    
    // unregister primitive handlers:
    //removePrimHandlers();
  }
  
}

