public var dataManip = new ( function() 
{
    /*================================================================
     * Description:
     *
     * displayBin(bin) takes as input an array of binary numbers and
     * converts it to a string
     */
    public function displayBin( bin )
    {
        var result = "";

        for ( var i = bin.length() - 1; i >= 0; i-- )
        {
            result += bin[ i ];
        }

        return( result );
    }


    /*================================================================
     * Description:
     * 
     * Returns inverse of a binary number, ie, puts a 1 where there
     * was a 0 and a 0 where there was a 1
     */
    public function inverse( bin )
    {
        var result = new Array();

        for ( var i = 0; i < bin.length(); i++ )
        {
            if ( bin[ i ] == 1 )
            {
                result[ i ] = 0;
            }
            else
            {
                result[ i ] = 1;
            }
        }

        return( result );
    }


    /*================================================================
     * Description:
     *
     * Absolute value.
     */
    public function abs( number )
    {
        if ( number >= 0 )
        {
            return( number );
        }
        else
        {
            return( -1 * number );
        }
    }


    /*================================================================
     * Description:
     *
     * binToDec(bin) takes as input a binary array such as one that
     * binToDec(dec) (see below) produces and returns the equivalent
     * decimal number.  Note that this only works for unsigned binary
     * numbers.
     */
    public function binToDec( bin )
    {
        var dec = 0;

        for ( var i = bin.length() - 1; i >= 0; --i )
        {
            dec = ( 2 * dec ) + bin[ i ];
        }
        
        return( dec );
    }


    /*================================================================
     * Description:
     *
     * decToBin(dec) does the inverse of binToDec(bin).  It takes as
     * input a decimal number and returns an array of 0s and 1s that
     * is equivalent to the binary representation.  The 0th element in
     * the array is the least significant (left-most digit in the
     * binary number.)
     *
     * example:
     * input  - 423
     * binary - 110100111
     * output - [ 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, ..., 0 ]
     */
    public function decToBin( dec )
    {
        var bin = new Array();

        for ( var i = 0; i < 32; i++ )
        {
            bin[ i ] = 0;
        }

        for ( var i = 0; dec != 0; i++ )
        {
            bin[ i ] = dec % 2;
            dec /= 2;
        }

        return( bin );
    }


    /*================================================================
     * Description:
     *
     * decToHex(dec) takes as input a decimal number and returns a
     * string that is equivalent to the hex representation of the
     * input
     *
     * example:
     * input  - 423
     * output - "0x000001A7"
     */
    public function decToHex( dec )
    {
        var hex = "";
        
        for ( var i = 0; i < 8; i++ )
        {
            hex = numberToChar( dec % 16 ) + hex;
            dec /= 16;
        }

        hex = "0x" + hex;
        return( hex );
    }


    /*================================================================
     * Description:
     *
     * numberToChar(dec) takes as input a number between 0 and 16 and
     * outputs the equivalent hex value as a string
     */
    public function numberToChar( dec )
    {
        if      (dec >= 0 && dec <= 9) { return ("" + dec); }
        else if (dec == 10)            { return "a"; }
        else if (dec == 11)            { return "b"; }
        else if (dec == 12)            { return "c"; }
        else if (dec == 13)            { return "d"; }
        else if (dec == 14)            { return "e"; }
        else if (dec == 15)            { return "f"; }
        else                           { return "ERROR"; }
    }


    /*================================================================
     * Description:
     *
     * power(a, b) raises (integer) a to the (positive integer) b power.
     */
    public function power( a, b )
    {
        var result = 1;

        for ( var i = 0; i < b; i++ )
        {
            result *= a;
        }

        return( result );
    }
} )();



/*
 *   Local Variables:
 *   tab-width: 0
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 4
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
