/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
    This test is derived from the TestCase base class.

    Args:
    logWriter        -  A writer object that is used to log any messages.
                        User can either pass in a writer object or null.

    warningWriter    -  A writer object that is used to log any warning messages.
                        User can either pass in a writer object or null.

    errorWriter      -  A writer object that is used to log any error messages
                        User can either pass in a writer object or null.

    Returns:
    n/a

 */
public function TestBasic( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.obstest.TestBasic", logWriter, warningWriter, errorWriter)
{
  /****************************************************************
   * Global variable initionalizations.
   ****************************************************************/
  const var scriptEhId = 0x101;

  const var rctx = services["esf routing"].getRoutingContext();


  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    const var prefix = "TestBasic-";
    logInfo( "Beginning OBSTEST Event Handler Unit Test" );
    const var p = pkg.esf.obstest.util;
    var phase;

    // TODO make sure that nothing else is using this event handler
    phase = "Init:";
    if (!p.start( rctx, scriptEhId ))
    {
      logError( phase + "start fail." );
    }
    else
    {
      logInfo( phase + "start success." );
    }


    phase = "Test:";
    function testObservable( name )
    {
      if (!
             (new pkg.esf.obstest.util.OpList())
            .addSet( name, 134 )
            .perform( rctx, scriptEhId )

          )  logError( phase + "Set fail for " + name + "." );

      if (!
             (new pkg.esf.obstest.util.OpList())
            .addTrigger( name, 1 )
            .perform( rctx, scriptEhId )
          )  logError( phase + "Trigger fail for " + name + "." );

      if (!
             (new pkg.esf.obstest.util.OpList())
            .addTriggerWithCacheClear( name, 1 )
            .perform( rctx, scriptEhId )
          )  logError( phase + "Trigger with cache clear fail for " + name + "." );
    }

    testObservable( "obstest_Simple"     );
    testObservable( "obstest_Structured" );
    testObservable( "obstest_Array0"     );
    testObservable( "obstest_Array1"     );
    testObservable( "obstest_Array2"     );

  }

}





