/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
 * File Description:
 *   This file contains Ets Wrapper.os, which is a wrapper for ETS
 *   in the hostbuild.
 */


/*=============================================================================
 * Description:
 *   Class Constructor.
 *   
 * Args:
 *   nodeId
 *   
 * Returns:
 *   n/a
 */
public function Wrapper( nodeId, taskController ) extends pkg.util.Subsystem( nodeId, "Wrapper" )
{
  var transId = 0;
  var prim    = null;
  var esf = services["esf routing"];
  var rctx = esf.getRoutingContext();
  
  
  function waitForPrim( Type )
  {
    var prim;
    
    while( ((prim=task.waitForPrim()) != null) &&
           !(prim instanceof Type) )
    {}
    
    // is there a need to make a copy?  I don't understand why we
    // need to do this:
    return new Type(prim);
  }
  
  
  /***********************************************************************************
   * Version Request/Confirm
   ***********************************************************************************/  
  public function versionReq( )
  {
    rctx.sendPrim( new ETS_VERSION_REQ( nodeId,
                                        task.getEhId() ) );
  }
  
  public function waitForVersionCnf()
  {
    return( waitForPrim( ETS_VERSION_CNF ) );
  }
     
  /***********************************************************************************
   * Memory Read Request/Confirm
   ***********************************************************************************/  
  public function memReadReq( transactionId,
                              address,
                              addressType,
                              dataUnit,
                              numUnits )
  {
    rctx.sendPrim( new ETS_MEM_READ_REQ( nodeId,
                                         task.getEhId(),
                                         transactionId,
                                         address,
                                         addressType,
                                         dataUnit,
                                         numUnits ) );
  }
  
  public function waitForMemReadCnf()
  {
    return( waitForPrim( ETS_MEM_READ_CNF ) );
  }
  
  /***********************************************************************************
   * Memory Read Request/Confirm
   ***********************************************************************************/  
  public function memWriteReq( transactionId,
                               address,
                               addressType,
                               dataUnit,
                               dataArray )
  {
    rctx.sendPrim( new ETS_MEM_WRITE_REQ( nodeId,
                                          task.getEhId(),
                                          transactionId,
                                          address,
                                          addressType,
                                          dataUnit,
                                          dataArray.length(),
                                          dataArray ) );
  }
  
  public function waitForMemWriteCnf()
  {
    return( waitForPrim( ETS_MEM_WRITE_CNF ) );
  }
  


  function handlePrim( prim )
  {
    if( prim.getSourceNodeId() == nodeId )
    {
      this.prim = prim;
    }
  }
  
  function isBlocked()
  {
    return prim == null;
  }
  
  taskController.addPrimHandlers( new Array( ETS_VERSION_CNF,
                                             ETS_MEM_READ_CNF,
                                             ETS_MEM_WRITE_CNF ),
                                  handlePrim );
}


/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
