/*=============================================================================
 *     Copyright Texas Instruments 2001. All Rights Reserved.
 */

/**
 * A utility class, to keep a list of handlers.
 */
function SubHandlerList()
{
  var handlerList = new Array();
  
  /**
   * 
   */
  public function addHandler( memHandler )
  {
    handlerList[ handlerList.length() ] = memHandler;
    
    return( true );
  }
  
  /**
   * 
   */
  public function getSubHandlerList( address )
  {
    var subHandlerList = new Array();
    
    for( var i = 0;
         i < handlerList.length();
         i++ )
    {
      if( ( address >= handlerList[i].getStartAddr() ) &&
          ( address <= handlerList[i].getEndAddr() ) )
      {
        subHandlerList[ subHandlerList.length() ] = handlerList[i];
      }
    }
    
    return( subHandlerList );
  }  
}


/**
 * This is a memory handling class. The class implements the VirtualMemoryHandler
 * methods for reading and writing to memory. This class 
 */
public function MemHandler() extends ti.chimera.esf.sut.VirtualMemorySimulation.VirtualMemoryHandler()
{
  var subHandlerList = new SubHandlerList();
  
  /**
   * 
   */
  public function addHandler( memHandler )
  {
    pkg.output.logInfoMsg("MemHandler","Adding " + memHandler.getName() + " responsible for address range: " +
                          "0x" + java.lang.Long.toHexString(memHandler.getStartAddr()) + " - 0x" + java.lang.Long.toHexString(memHandler.getEndAddr()));
    
    subHandlerList.addHandler( memHandler );
  }

  /**
   * 
   */
  public function handleRead( baseAddr, unit, numUnits )
  {
    var readHandlerList = subHandlerList.getSubHandlerList( baseAddr );
    var dataRead = false;
    var buf = new Array();
    
     /*
      * Inform the sub handlers
      */
    for( var i = 0;
         i < readHandlerList.length();
         i++ )
    {
      if( dataRead == false )
      {
        buf = readHandlerList[ i ].handleRead( baseAddr, unit, numUnits );
        
        if( buf.length() >= numUnits )
        {
          dataRead = true;
        }
      }
      else
      {
        /*
         * just Inform the other handlers of the read without reading data back.
         */
        readHandlerList[ i ].handleRead( baseAddr, unit, numUnits );      
      }
    }
    
    if(dataRead)
      return( buf );
    else
      return null;
  }

  /**
   * 
   */
  public function handleWrite( baseAddr, unit, numUnits, buf )
  {
    var writeHandlerList = subHandlerList.getSubHandlerList( baseAddr );
    var dataWritten = false;
    var numWritten = 0;
    
     /*
      * Inform the sub handlers
      */
    for( var i = 0;
         i < writeHandlerList.length();
         i++ )
    {
      if( dataWritten == false )
      {
        numWritten += writeHandlerList[ i ].handleWrite( baseAddr, unit, numUnits, buf );
        
        if( numWritten >= numUnits )
        {
          dataWritten = true;
        }
      }
      else
      {
        /*
         * just Inform the other handlers of the write.
         */
        writeHandlerList[ i ].handleWrite( baseAddr, unit, numUnits, buf );
      }
    }
    
    return true;
  }
}

/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */

