/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
    This test is derived from the TestCase base class.

    This test case verifies that edge cases concerning the size of entries
    and the sizes of primitives are handled well.


    Args:
    logWriter        -  A writer object that is used to log any messages.
                        User can either pass in a writer object or null.

    warningWriter    -  A writer object that is used to log any warning messages.
                        User can either pass in a writer object or null.

    errorWriter      -  A writer object that is used to log any error messages
                        User can either pass in a writer object or null.

    Returns:
    n/a

 */
public function TestStatsCalc( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.age.TestStatsCalc", logWriter, warningWriter, errorWriter)
{
  /****************************************************************
   * Global variable initionalizations.
   ****************************************************************/
  const var scriptEhId = 0x101;

  const var rctx = services["esf routing"].getRoutingContext();


  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    logInfo( "Beginning Age Event Handler Unit Test- TestBufferExhaustion" );
    const var p = pkg.esf.age.util;
    var phase;
    const var preallocSize = 20;
    const var preallocCount = 4;
    const var refreshPeriod = 0;

    // Make the system quiet
    phase = "Init:";
    if (!p.unitTestStart( rctx, scriptEhId, phase, preallocCount, preallocSize, 0 )) return;

    phase = "TestBufferExhaustion:";
    const var seed = 0x2345423;
    const var entryHeaderSize = 4;  /* Could change; unlikely */
    const var osEntry = [];
    var osEntryCount = 0;

    const var initialStats = p.getStats( rctx, scriptEhId, null );

    logInfo( "Initial Stats: " + initialStats.toString() );

    const var firstDiff = 12;
    if (!p.setConfiguration( rctx, scriptEhId, firstDiff, preallocSize, refreshPeriod ) ) logError( phase + " buf cfg fail." );
    if (!p.triggerBufferService( rctx, scriptEhId) ) logError( phase + "Buffer Service Fail." );


    const var firstDiffStats = p.getStats( rctx, scriptEhId, initialStats );
    logInfo( "First Diff Stats: " + firstDiffStats.toString() );
    const var firstDiffValue = firstDiffStats.getInstantaneousAllocatedCount();
    logInfo( "FirstDiff = " + firstDiff + " And queried diff is "
             + firstDiffValue );
    if (firstDiffValue != firstDiff) logError(" Material balance failure! ");

    if (!p.unsetSubscriber( rctx, scriptEhId ) ) logError( phase + "Unsubscribe fail." );

    const var secondDiffStats = p.getStats( rctx, scriptEhId, firstDiffStats );
    logInfo( "Second Diff Stats: " + secondDiffStats.toString() );
    const var secondDiffValue = secondDiffStats.getInstantaneousAllocatedCount();
    logInfo( "SecondDiff=0 And queried diff is "
             + secondDiffValue );
    if (secondDiffValue != 0) logError(" Material balance failure in second diff");

    const var fourthDiff = 9;
    if (!p.setConfiguration( rctx, scriptEhId, fourthDiff, preallocSize, refreshPeriod ) ) logError( phase + " buf cfg fail." );
    if (!p.triggerBufferService( rctx, scriptEhId) ) logError( phase + "Buffer Service Fail." );
    const var thirdDiffStats = p.getStats( rctx, scriptEhId, secondDiffStats );
    logInfo( "Third Diff Stats: " + thirdDiffStats.toString() );
    if (thirdDiffStats.getDiffAggregateAllocs() != 0) logError(" Material balance failure in third diff: no allocs expected");

    if (!p.setSubscriber( rctx, scriptEhId ) ) logError( phase + "Subscribe fail." );
    const var fourthDiffStats = p.getStats( rctx, scriptEhId, thirdDiffStats );
    logInfo( "Fourth Diff Stats: " + fourthDiffStats.toString() );
    const var fourthDiffValue = fourthDiffStats.getInstantaneousAllocatedCount();
    logInfo( "fourthDiff = " + fourthDiff + " And queried diff is "
             + fourthDiffValue );
    if (fourthDiffValue != fourthDiff) logError(" Material balance failure in fourth diff ");


    const var finalStats = p.getStats( rctx, scriptEhId, initialStats );

    logInfo( "Final Stats: " + finalStats.toString() );

    phase = "Cleanup:";
    p.unitTestEnd( rctx, scriptEhId, phase );

  }

}




