/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
    This test is derived from the TestCase base class.

    During development, I had a problem with the last entry written not
    getting written to a primitive. This test helped me find it.

    Args:
    logWriter        -  A writer object that is used to log any messages.
                        User can either pass in a writer object or null.

    warningWriter    -  A writer object that is used to log any warning messages.
                        User can either pass in a writer object or null.

    errorWriter      -  A writer object that is used to log any error messages
                        User can either pass in a writer object or null.

    Returns:
    n/a

 */
public function TestLastEntryInPrim( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.age.TestLastEntryInPrim", logWriter, warningWriter, errorWriter)
{
  /****************************************************************
   * Global variable initionalizations.
   ****************************************************************/
  const var scriptEhId = 0x101;

  const var rctx = services["esf routing"].getRoutingContext();


  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    logInfo( "Beginning Age Event Handler Unit Test- TestLastEntryInPrim" );
    const var p = pkg.esf.age.util;
    var phase;
    const var preallocSize = 29;
    const var preallocCount = 4;
    const var refreshPeriod = 0;


    // TODO make sure that nothing else is using this event handler



    // Make the system quiet

    phase = "Init:";
    if (!p.unitTestStart( rctx, scriptEhId, phase, preallocCount, preallocSize, 0 )) return;


    phase = "TestLastEntryInPrim:";
    const var osEntries = [];
    const var osEntryCount = 3;
    for (var i = 0; i < osEntryCount; ++i)
    {
      osEntries[ i ] = new p.OSEntry();
      osEntries[ i ].randomize( 4 , 3 , 1 , i );
      osEntries[ i ].setTag( 0xAA00 + (i % 0xFF) );

      if (!p.writeBasicEntry(
            rctx
          , scriptEhId
          , osEntries[ i ]
          , ti.th.prim.Age_AgeEh_InsertEntryResult.AGE_AGEEH_INSERT_ENTRY_SUCCESS
        ) ) logError( phase + "Entry write fail." );
    }


    phase = "VerifyEntry:";
    if (!p.forceRelinquish( rctx, scriptEhId ) ) logError( phase + "Relinquish Fail." );
    var trap = p.attachTrap( rctx, scriptEhId );
    if (!p.triggerBufferService( rctx, scriptEhId) ) logError( phase + "Buffer Service Fail." );
    var decoder = pkg.esf.age.util.acquireEntryDecoder( logInfo, logWarning, logError );
    decoder.setTestReporter( new function () extends ti.test.TestReporter() {
        public function report( string ) {
          logInfo( "TR: " + string );
        }
      } ()
    );
    if (!p.forceRelinquish( rctx, scriptEhId ) ) logError( phase + "Relinquish Fail." );
    p.detachDecodeTrap( rctx, trap, decoder );
    const var decodedEntryCount = decoder.entryCount();
    logInfo( "Decoded entry count was " + decodedEntryCount
             + " and osEntryCount is " + osEntryCount );
    if (decodedEntryCount != osEntryCount)
    {
      logError( phase + "Expected " + osEntryCount
                + " entries but found " + decoder.entryCount() );
    }
    for (var i = 0; i < decodedEntryCount; ++i) {
      logInfo( "Inspecting entry i= " + i + ": Expected is " + osEntries[ i ].toString() );
      const var decodedEntry = decoder.get();
      if (!p.verifyBasicEntry( decodedEntry, osEntries[ i ] ) )
      {
        logError( phase + "Entry verify fail." );
      }
    }
    while( decoder.entryCount() > 0) {
      const var unhandled = decoder.get();
      logError( phase + "Unhandled Entry!" + unhandled );
    }
    for (
          var lostEntryIndex = decodedEntryCount
        ; lostEntryIndex < osEntryCount
        ; ++lostEntryIndex
        )
    {
      logError(" Lost the entry " + osEntries[ lostEntryIndex ] );
    }


    phase = "Cleanup:";
    p.unitTestEnd( rctx, scriptEhId, phase );

  }

}




