/*=============================================================================
 *     Copyright Texas Instruments 2002. All Rights Reserved.
 */


/*=============================================================================
    Description:
    This test is derived from the TestCase base class.

    Args:
    logWriter        -  A writer object that is used to log any messages.
                        User can either pass in a writer object or null.

    warningWriter    -  A writer object that is used to log any warning messages.
                        User can either pass in a writer object or null.

    errorWriter      -  A writer object that is used to log any error messages
                        User can either pass in a writer object or null.

    Returns:
    n/a

 */
public function TestBasic( logWriter, warningWriter, errorWriter )
  extends pkg.tf.TestCase( "esf.age.TestBasic", logWriter, warningWriter, errorWriter)
{
  /****************************************************************
   * Global variable initionalizations.
   ****************************************************************/
  const var scriptEhId = 0x101;

  const var rctx = services["esf routing"].getRoutingContext();


  //====================================================================================
  /**
   * Overrides the runTest() method in TestCase base class.
   *
   */
  public function runTest()
  {
    var prim;

    const var prefix = "TestBasic-";
    logInfo( "Beginning Age Event Handler Unit Test" );
    const var p = pkg.esf.age.util;
    var phase;

    // TODO make sure that nothing else is using this event handler

    // Make the system quiet

    phase = "Init:";
    if (!p.unitTestStart( rctx, scriptEhId, phase, 8, 500, 0 )) return;

    phase = "TestEntry:";
    const var osEntry = new p.OSEntry();
    osEntry.set(
        0x1425
      , [-1412623820, 0x12345678, -1737075662]
      , [0x1357, 0x2468, 0xACE1]
      , [0x15, 0x26, 0x37]
      );

    if (!p.writeBasicEntry(
          rctx
        , scriptEhId
        , osEntry
        , ti.th.prim.Age_AgeEh_InsertEntryResult.AGE_AGEEH_INSERT_ENTRY_SUCCESS
      ) )
    {
      logError( phase + "Entry write fail." );
    }

    phase = "VerifyEntry:";
    if (!p.forceRelinquish( rctx, scriptEhId ) ) logError( phase + "Relinquish Fail." );
    var trap = p.attachTrap( rctx, scriptEhId );
    if (!p.triggerBufferService( rctx, scriptEhId) ) logError( phase + "Buffer Service Fail." );

    var decoder = pkg.esf.age.util.acquireEntryDecoder( logInfo, logWarning, logError );

    p.detachDecodeTrap( rctx, trap, decoder );
    if (decoder.entryCount() != 1) logError( phase + "Expected 1 entry but found " + decoder.entryCount() );
    if (!p.verifyBasicEntry(
            decoder.get()
          , osEntry
          )
        )
    {
      logError( phase + "Entry verify fail." );
    }

    phase = "Cleanup:";
    p.unitTestEnd( rctx, scriptEhId, phase );

  }

}




