/*=============================================================================
 *   Copyright Texas Instruments, Inc., 2005.  All Rights Reserved.
 */

/**
 * A sample <code>TestSuite</code> for the purposes of testing the regression
 * test plugin.
 */
public function TestSuite(args...) 
  extends pkg.tf.TestSuite( "Dummy Test Suite")
{ 
  
  // DEFINE AND DISPLAY TEST CASE IDS ======================================
  
  testDescMap.put("Activate.AFC.1","Verify Activate with no frequency binning");
  testDescMap.put("Activate.AFC.10","Verify Activate with AFC Lock failure. Single Uarfcn so Activate fails");
  testDescMap.put("Activate.AFC.11","Verify Activate with initial search failure causing moving to next Uarfcn where Acquisition succeeds");
  
 /**
  ** ==============================================================
  **  @FUNCTION      : Activate_AFC_1
  **
  ** @DESCRIPTION   : This is a public member function of CltdSequencing
  **                  This function does run the actual test cases
  ** 
  ** @PARAM  : 
  **  parameters... - none
  **
  ** @RETURN VALUE  : void
  ** 
  ** @SIDE EFFECTS  : None
  ** ==============================================================
  **/
  public function Activate_AFC_1()
  {
    pkg.output.writeln("  In ACTIVATE_AFC_1 method");    
    pkg.log.info("In ACTIVATE_AFC_1 method, an infomation message");
    return STATUS_SUCCESS;
  }
  
  
  
 /**
  ** ==============================================================
  **  @FUNCTION      : activate_AFC_10
  **
  ** @DESCRIPTION   : This is a public member function of CltdSequencing
  **                  This function does run the actual test cases
  ** 
  ** @PARAM  : 
  **  parameters... - none
  **
  ** @RETURN VALUE  : void
  ** 
  ** @SIDE EFFECTS  : None
  ** ==============================================================
  **/
  public function Activate_AFC_10()
  {
     pkg.output.writeln("  In ACTIVATE_AFC_10 method");
     pkg.log.error("In ACTIVATE_AFC_10 method, an error message");
     return STATUS_SUCCESS;
  }


  /**
   ** ==============================================================
   **  @FUNCTION      : Activate_AFC_11
   **
   ** @DESCRIPTION   : This is a public member function of CltdSequencing
   **                  This function does run the actual test cases
   ** 
   ** @PARAM  : 
   **  parameters... - none
   **
   ** @RETURN VALUE  : void
   ** 
   ** @SIDE EFFECTS  : None
   ** ==============================================================
   **/
  public function Activate_AFC_11()
  {
     pkg.output.writeln("  In ACTIVATE_AFC_11 method");
     pkg.log.warning("In ACTIVATE_AFC_11 method, a warning message");
     return STATUS_SUCCESS;
  } 
}

/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
