/******************************************************************************
 *        Copyright Texas Instruments 2003. All Rights Reserved.
 */


const var currentTimeMillis = java.lang.System.currentTimeMillis;

/**
 * Run a loopback bandwidth test, with the specified parameters.
 * 
 * @param size    the primitive size in multiples of four byte words.  This
 *    parameter must be >= 4 (2 words for prim hdr, 2 words for trans-id and
 *    count fields)
 * @param repeat  the number of iterations to run the test for
 * @param idx     if multiple tests are run in parallel, this must be set
 *    uniquely for each, to ensure that the different parallel tests have
 *    different transaction-ids
 */
public function loopbackTest( size, repeat, idx )
{
  var rctx = services["esf routing"].getRoutingContext();
  var data = [];
  
  size = java.lang.Math.max( size, 4 );
  
  for( var i=0; i<(size-4); i++ )
    data[i] = i;
  
  var startTimeMs   = currentTimeMillis();
  var waitingTimeMs = 0;
  
  for( var i=0; i<repeat; i++ )
  {
    var transId = (idx << 8) | (i & 0xff);
    var req = new ETS_LOOPBACK_REQ(
                /* source ehId */          0x0101 + idx,
                /* transId */              transId,
                /* data */                 data
              );
    
    var t = currentTimeMillis();
    
    rctx.sendAndWaitForPrim( req, function(prim) {
      return prim.getTransId() != transId;
    }, rctx.type(ETS_LOOPBACK_CNF) );
    
    waitingTimeMs += currentTimeMillis() - t;
  }
  
  var totalTimeMs = currentTimeMillis() - startTimeMs;
  var avgTimeMs   = waitingTimeMs.castToInexactNumber()/repeat.castToInexactNumber();
  
  pkg.output.logInfoMsg("-------------------------------------------------");
  pkg.output.logInfoMsg("params: size=" + (size*4) + "b, repeat=" + repeat + ", idx=" + idx);
  pkg.output.logInfoMsg("total time:      " + totalTimeMs + "ms");
  pkg.output.logInfoMsg("waiting time:    " + waitingTimeMs + "ms");
  pkg.output.logInfoMsg("script overhead: " + (totalTimeMs - waitingTimeMs) + "ms");
  pkg.output.logInfoMsg("avg time:        " + avgTimeMs + "ms per transaction");
  pkg.output.logInfoMsg("bandwidth:       " + ((size*4*1000*2).castToInexactNumber()/avgTimeMs) + " b/sec");
  pkg.output.logInfoMsg("rate:            " + ((repeat*1000*2).castToInexactNumber()/waitingTimeMs.castToInexactNumber()) + " prim/sec");
  pkg.output.logInfoMsg("-------------------------------------------------");
}

