/******************************************************************************
 *        Copyright Texas Instruments 2003. All Rights Reserved.
 */

/**
 * Run parallel loopback bandwidth tests.  Each test consists of sending a 
 * number of <code>ETS_LOOPBACK_REQ</code> primitives, and waiting for the 
 * response <code>ETS_LOOPBACK_CNF</code>.  These tests are run in parallel
 * to create a higher bandwidth test where more threads are hammering on
 * the routing and loggging system at the same time.
 */
public function ParallelLoopbackBandwidthTest(args...)
  extends pkg.tf.TestCase("Parallel Loopback Bandwidth")
{
  /**
   * The entry point to the test is this method.
   */
  public function runTest()
  {
    var threads = [];
    
    var sizes   = [ 10, 100, 1000 ];
    var repeats = [ 80, 40, 20 ];
    
    for( var i=0; i<20; i++ )
    {
      threads[i] = new java.lang.Thread( function(i) {
        return function() {
          
          java.lang.Thread.sleep(100);
          pkg.output.logInfoMsg("starting thread: " + i);
          
          pkg.chimera.routing.loopbackTest( 
            sizes[ i % sizes.length() ], 
            repeats[ i % repeats.length() ],
            i
          );
          
        };
      }(i), "parallel bandwidth test thread " + i );
      
      threads[i].start();
    }
    
    pkg.output.logInfoMsg("waiting for threads");
    
    for( var i=0; i<threads.length(); i++ )
      threads[i].join();
    
    pkg.output.logInfoMsg("done");
  }
}

