/*=============================================================================
 *     Copyright Texas Instruments, Inc., 2002.  All Rights Reserved.
 */


/**
 * Create a chart that displays heap size and heap in use over time.
 */
public var memChart = new (function() {
  
  var runtime = java.lang.Runtime.getRuntime();

  // Get the chart factory service
  var chartFactory = services["chart factory"];

  /**
   * create the chart specifying the chart type recquired. 
   * Here we specify the "time based offset" chart type.
   */
  var chartContext  = chartFactory.createChart (
                                                chartFactory.OFFSET_XY_TIME_BASED /*chart-type*/, 
                                                "Memory Use",  /*chart-title*/ 
                                                null           /*legend*/ 
                                                );

  //set auto-range to true
  chartContext.setAutoRange(true);

  //set the legend names The legends inform the chart how many plot values it can receive.
  chartContext.setLegend( [ "Total Heap", "Heap Used" ] );

  //display the chart in a view.Also specify a runnable to be called when the view is closed.
  // Any clean up of the chart can be done in the runnable.
  services["chart view"].displayChart(chartContext, function() { stop(); } /*runnable*/ );

  var timer = new swing.Timer( 500 /*ms*/, new (function() extends java.awt.event.ActionListener() {
    
    public function actionPerformed(evt)
    {
      var freeMem  = (runtime.freeMemory())/1024;
      var totalMem = (runtime.totalMemory())/1024;

      // add the plot values to the chart context.
      chartContext.addData( [ totalMem, totalMem - freeMem ] );
      
    }
    
  })() );
  
  public var start = timer.start;
  public var stop  = timer.stop;
  
})();


/*
 *   Local Variables:
 *   tab-width: 2
 *   indent-tabs-mode: nil
 *   mode: java
 *   c-indentation-style: java
 *   c-basic-offset: 2
 *   eval: (c-set-offset 'statement-cont '0)
 *   eval: (c-set-offset 'substatement-open '0)
 *   eval: (c-set-offset 'case-label '+)
 *   eval: (c-set-offset 'inclass '+)
 *   eval: (c-set-offset 'inline-open '0)
 *   End:
 */
