/******************************************************************************
 *        Copyright Texas Instruments 2003. All Rights Reserved.
 */

/**
 * Run some tests that create and release resources to verify that things
 * are getting garbage collected properly.
 * <ul>
 * <li> Simple Dialog
 * <li> Simple View
 * <li> Simple View with DnD drop target
 * </ul>
 */
public function GcTest(args...)
  extends pkg.tf.TestCase("Garbage Collection")
{
  /**
   * The entry point to the test is this method.
   */
  public function runTest()
  {
    var finalized;
    var obj;
    
    /****************************************************************************
     * Called at start of test, to initialze variables and store the object
     * that should be freed when we waitForFinalizer().  That object, or
     * something that should be GC'd at the same time, should implement a
     * finalize method to set <code>finalized</code> to <code>true</code>.
     * 
     * @param o   the object to test
     */
    function startTest(o)
    {
      finalized = false;
      obj  = o;
    }
    
    /****************************************************************************
     */
    function waitForFinalizer()
    {
      obj = null;
      while(!finalized)
      {
        pkg.output.write(".");
        java.lang.System.gc();
        java.lang.Thread.sleep(1000);
      }
    }
    
    /***************************************************************************/
    pkg.output.logInfoMsg(" *** Test 1:  Simple Dialog");
    startTest( windowManager.getDialog("Test") );
    obj.getContentPane().add( 
      new swing.JButton( new (function() extends pkg.util.ActionAdapter("Close",null,null, function(evt) {
        obj.setVisible(false);
      }) {
        function finalize() { finalized = true; }
      })() ) );
    obj.pack();
    obj.setVisible(true);
    obj.showModal();
    obj.dispose();
    waitForFinalizer();
    pkg.output.logInfoMsg("done!");
    
    /***************************************************************************/
    pkg.output.logInfoMsg(" *** Test 2:  Simple View");
    registry.register( new (function() extends ti.chimera.Plugin( main, "Test" ) {
      
      registerServiceFactory( function() {
        
        return new (function() extends ti.chimera.Service("test") {
          
          public function createView()
          {
            var view = new TestView();
            addResource( new ViewResource(view) );
            return view;
          }
          
        })();
        
      } );
      
      function TestView()
        extends ti.chimera.View( main, "Test", null )
      {
        var component = new swing.JButton( new pkg.util.ActionAdapter("Close",null,null,
                                                                      function(evt) {
                                                                        close();
                                                                      }) );
        
        public function getComponent()
        {
          return component;
        }
        
        function finalize()
        {
          finalized = true;
        }
      }
      
    })() );
    startTest( services["test"].createView() );
    waitForFinalizer();
    pkg.output.logInfoMsg("done!");
    
    /***************************************************************************/
    pkg.output.logInfoMsg(" *** Test 3:  Simple View with DnD target");
    pkg.output.logInfoMsg("test not implemented yet");
    pkg.output.logInfoMsg("done!");
  }
}

