/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.impl.XML11DTDScannerImpl;
import org.apache.xerces.impl.XML11DocumentScannerImpl;
import org.apache.xerces.impl.XML11NSDocumentScannerImpl;
import org.apache.xerces.impl.XML11NamespaceBinder;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLVersionDetector;
import org.apache.xerces.impl.dtd.XML11DTDProcessor;
import org.apache.xerces.impl.dtd.XML11DTDValidator;
import org.apache.xerces.impl.dtd.XML11NSDTDValidator;
import org.apache.xerces.impl.dv.DTDDVFactory;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.IntegratedParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;

public class XML11Configuration
extends IntegratedParserConfiguration {
    protected static final String XML11_DATATYPE_VALIDATOR_FACTORY = "org.apache.xerces.impl.dv.dtd.XML11DTDDVFactoryImpl";
    protected XMLVersionDetector fVersionDetector = new XMLVersionDetector();
    protected XML11NSDocumentScannerImpl fXML11NSDocScanner = null;
    protected XML11DocumentScannerImpl fXML11DocScanner = null;
    protected XML11DTDScannerImpl fXML11DTDScanner = null;
    protected XML11NSDTDValidator fXML11NSDTDValidator = null;
    protected XML11DTDValidator fXML11DTDValidator = null;
    protected XML11DTDProcessor fXML11DTDProcessor = null;
    protected XML11NamespaceBinder fXML11NamespaceBinder = null;
    protected DTDDVFactory fXML11DatatypeFactory = null;

    public XML11Configuration() {
        this(null, null, null);
    }

    public XML11Configuration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public XML11Configuration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this(symbolTable, xMLGrammarPool, null);
    }

    public XML11Configuration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, XMLComponentManager xMLComponentManager) {
        super(symbolTable, xMLGrammarPool, xMLComponentManager);
    }

    public boolean parse(boolean bl) throws XNIException, IOException {
        if (this.fInputSource != null) {
            try {
                this.fVersionDetector.reset(this);
                this.reset();
                short s = this.fVersionDetector.determineDocVersion(this.fInputSource);
                if (s == 2) {
                    this.configureXML11Pipeline();
                }
                this.fVersionDetector.startDocumentParsing((XMLEntityHandler)((Object)this.fScanner), s);
                this.fInputSource = null;
            }
            catch (XNIException xNIException) {
                throw xNIException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new XNIException(exception);
            }
        }
        try {
            return this.fScanner.scanDocument(bl);
        }
        catch (XNIException xNIException) {
            throw xNIException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new XNIException(exception);
        }
    }

    protected void configureXML11Pipeline() {
        if (this.fXML11DatatypeFactory == null) {
            this.fXML11DatatypeFactory = DTDDVFactory.getInstance(XML11_DATATYPE_VALIDATOR_FACTORY);
        }
        this.setProperty("http://apache.org/xml/properties/internal/datatype-validator-factory", this.fXML11DatatypeFactory);
        if (this.fXML11DTDScanner == null) {
            this.fXML11DTDScanner = new XML11DTDScannerImpl();
        }
        if (this.fXML11DTDProcessor == null) {
            this.fXML11DTDProcessor = new XML11DTDProcessor();
        }
        this.fProperties.put("http://apache.org/xml/properties/internal/dtd-scanner", this.fXML11DTDScanner);
        this.fProperties.put("http://apache.org/xml/properties/internal/dtd-processor", this.fXML11DTDProcessor);
        this.fXML11DTDScanner.setDTDHandler(this.fXML11DTDProcessor);
        this.fXML11DTDProcessor.setDTDSource(this.fXML11DTDScanner);
        this.fXML11DTDProcessor.setDTDHandler(this.fDTDHandler);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.setDTDSource(this.fXML11DTDProcessor);
        }
        this.fXML11DTDScanner.setDTDContentModelHandler(this.fXML11DTDProcessor);
        this.fXML11DTDProcessor.setDTDContentModelSource(this.fXML11DTDScanner);
        this.fXML11DTDProcessor.setDTDContentModelHandler(this.fDTDContentModelHandler);
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.setDTDContentModelSource(this.fXML11DTDProcessor);
        }
        if (this.fFeatures.get("http://xml.org/sax/features/namespaces") == Boolean.TRUE) {
            if (this.fXML11NamespaceBinder == null) {
                this.fXML11NamespaceBinder = new XML11NamespaceBinder();
            }
            this.fProperties.put("http://apache.org/xml/properties/internal/namespace-binder", this.fXML11NamespaceBinder);
            if (this.fXML11NSDocScanner == null) {
                this.fXML11NSDocScanner = new XML11NSDocumentScannerImpl();
            }
            this.fScanner = this.fXML11NSDocScanner;
            this.fProperties.put("http://apache.org/xml/properties/internal/document-scanner", this.fXML11NSDocScanner);
            if (this.fXML11NSDTDValidator == null) {
                this.fXML11NSDTDValidator = new XML11NSDTDValidator();
            }
            this.fProperties.put("http://apache.org/xml/properties/internal/validator/dtd", this.fXML11NSDTDValidator);
            this.fXML11NSDocScanner.setDTDValidator(this.fXML11NSDTDValidator);
            this.fXML11NSDocScanner.setDocumentHandler(this.fXML11NSDTDValidator);
            this.fXML11NSDTDValidator.setDocumentSource(this.fXML11NSDocScanner);
            this.fXML11NSDTDValidator.setDocumentHandler(this.fDocumentHandler);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.setDocumentSource(this.fXML11NSDTDValidator);
            }
            this.fLastComponent = this.fXML11NSDTDValidator;
            this.fXML11NSDocScanner.reset(this);
            this.fXML11NSDTDValidator.reset(this);
            this.fXML11NamespaceBinder.reset(this);
        } else {
            if (this.fXML11DocScanner == null) {
                this.fXML11DocScanner = new XML11DocumentScannerImpl();
            }
            this.fScanner = this.fXML11DocScanner;
            this.fProperties.put("http://apache.org/xml/properties/internal/document-scanner", this.fXML11DocScanner);
            if (this.fXML11DTDValidator == null) {
                this.fXML11DTDValidator = new XML11DTDValidator();
            }
            this.fProperties.put("http://apache.org/xml/properties/internal/validator/dtd", this.fXML11DTDValidator);
            this.fXML11DocScanner.setDocumentHandler(this.fXML11DTDValidator);
            this.fXML11DTDValidator.setDocumentSource(this.fXML11DocScanner);
            this.fXML11DTDValidator.setDocumentHandler(this.fDocumentHandler);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.setDocumentSource(this.fXML11DTDValidator);
            }
            this.fLastComponent = this.fXML11DTDValidator;
            this.fXML11DocScanner.reset(this);
            this.fXML11DTDValidator.reset(this);
        }
        this.fXML11DTDScanner.reset(this);
        this.fXML11DTDProcessor.reset(this);
        if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
            if (this.fSchemaValidator == null) {
                this.fSchemaValidator = new XMLSchemaValidator();
                this.fProperties.put("http://apache.org/xml/properties/internal/validator/schema", this.fSchemaValidator);
                this.addComponent(this.fSchemaValidator);
                if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                    XSMessageFormatter xSMessageFormatter = new XSMessageFormatter();
                    this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xSMessageFormatter);
                }
            }
            this.fLastComponent.setDocumentHandler(this.fSchemaValidator);
            this.fSchemaValidator.setDocumentSource(this.fLastComponent);
            this.fSchemaValidator.setDocumentHandler(this.fDocumentHandler);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.setDocumentSource(this.fSchemaValidator);
            }
            this.fLastComponent = this.fSchemaValidator;
        }
    }
}

