/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.StringReader;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMInput;
import org.w3c.dom.ls.DOMParser;
import org.w3c.dom.ls.DOMParserFilter;
import org.w3c.dom.ls.DOMResourceResolver;

public class DOMParserImpl
extends AbstractDOMParser
implements DOMParser,
DOMConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String PSVI_AUGMENT = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected String fSchemaType = null;
    protected boolean fBusy = false;
    protected static final boolean DEBUG = false;
    private Vector fSchemaLocations = new Vector();
    private String fSchemaLocation = null;

    public DOMParserImpl(String string, String string2) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", string));
        if (string2 != null) {
            if (string2.equals(Constants.NS_DTD)) {
                this.fConfiguration.setFeature(XMLSCHEMA, false);
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                this.fSchemaType = Constants.NS_DTD;
            } else if (string2.equals(Constants.NS_XMLSCHEMA)) {
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
            }
        }
    }

    public DOMParserImpl(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        String[] stringArray = new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "supported-media-types-only", "certified", "well-formed"};
        this.fConfiguration.addRecognizedFeatures(stringArray);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("cdata-sections", true);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("infoset", true);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("supported-media-types-only", false);
        this.fConfiguration.setFeature("well-formed", true);
        this.fConfiguration.setFeature("certified", true);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
    }

    public DOMParserImpl(SymbolTable symbolTable) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XML11Configuration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
    }

    public DOMParserImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XML11Configuration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", xMLGrammarPool);
    }

    public void reset() {
        super.reset();
        if (this.fSkippedElemStack != null) {
            this.fSkippedElemStack.removeAllElements();
        }
        this.fSchemaLocations.clear();
        this.fRejectedElement.clear();
        this.fFilterReject = false;
        this.fSchemaType = null;
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    public DOMParserFilter getFilter() {
        return this.fDOMFilter;
    }

    public void setFilter(DOMParserFilter dOMParserFilter) {
        this.fDOMFilter = dOMParserFilter;
        if (this.fSkippedElemStack == null) {
            this.fSkippedElemStack = new Stack();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(String string, Object object) throws DOMException {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            try {
                if (string.equals("comments")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", bl);
                    return;
                }
                if (string.equals("datatype-normalization")) {
                    this.fConfiguration.setFeature(NORMALIZE_DATA, bl);
                    return;
                }
                if (string.equals("entities")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", bl);
                    return;
                }
                if (string.equals("supported-media-types-only") || string.equals("canonical-form")) {
                    if (!bl) return;
                    String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                    throw new DOMException(9, string2);
                }
                if (string.equals("namespaces")) {
                    this.fConfiguration.setFeature(NAMESPACES, bl);
                    return;
                }
                if (string.equals("cdata-sections") || string.equals("namespace-declarations") || string.equals("well-formed") || string.equals("infoset")) {
                    if (bl) return;
                    String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                    throw new DOMException(9, string3);
                }
                if (string.equals("validate")) {
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, bl);
                    if (this.fSchemaType != Constants.NS_DTD) {
                        this.fConfiguration.setFeature(XMLSCHEMA, bl);
                    }
                    if (!bl) return;
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    return;
                }
                if (string.equals("validate-if-schema")) {
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, bl);
                    if (!bl) return;
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, false);
                    return;
                }
                if (string.equals("whitespace-in-element-content")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", bl);
                    return;
                }
                if (string.equals("psvi")) {
                    this.fConfiguration.setFeature(PSVI_AUGMENT, true);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", "org.apache.xerces.dom.PSVIDocumentImpl");
                    return;
                }
                this.fConfiguration.setFeature(string, bl);
                return;
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
                throw new DOMException(8, string4);
            }
        }
        if (string.equals("error-handler")) {
            if (object instanceof DOMErrorHandler) {
                try {
                    this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)object);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", this.fErrorHandler);
                    return;
                }
                catch (XMLConfigurationException xMLConfigurationException) {}
                return;
            }
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string5);
        }
        if (string.equals("entity-resolver")) {
            if (object instanceof DOMResourceResolver) {
                try {
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper((DOMResourceResolver)object));
                    return;
                }
                catch (XMLConfigurationException xMLConfigurationException) {}
                return;
            }
            String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string6);
        }
        if (string.equals("schema-location")) {
            if (object instanceof String) {
                try {
                    if (this.fSchemaType == Constants.NS_XMLSCHEMA) {
                        this.fSchemaLocation = (String)object;
                        StringTokenizer stringTokenizer = new StringTokenizer(this.fSchemaLocation, " \n\t\r");
                        if (stringTokenizer.hasMoreTokens()) {
                            this.fSchemaLocations.clear();
                            this.fSchemaLocations.add(stringTokenizer.nextToken());
                            while (stringTokenizer.hasMoreTokens()) {
                                this.fSchemaLocations.add(stringTokenizer.nextToken());
                            }
                            this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.fSchemaLocations.toArray());
                            return;
                        } else {
                            this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", object);
                        }
                        return;
                    }
                    String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                    throw new DOMException(9, string7);
                }
                catch (XMLConfigurationException xMLConfigurationException) {}
                return;
            }
            String string8 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string8);
        }
        if (string.equals("schema-type")) {
            if (object instanceof String) {
                try {
                    if (object.equals(Constants.NS_XMLSCHEMA)) {
                        this.fConfiguration.setFeature(XMLSCHEMA, true);
                        this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
                        this.fSchemaType = Constants.NS_XMLSCHEMA;
                        return;
                    }
                    if (!object.equals(Constants.NS_DTD)) return;
                    this.fConfiguration.setFeature(XMLSCHEMA, false);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                    this.fSchemaType = Constants.NS_DTD;
                    return;
                }
                catch (XMLConfigurationException xMLConfigurationException) {}
                return;
            }
            String string9 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string9);
        }
        if (string.equals("http://apache.org/xml/properties/dom/document-class-name")) {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", object);
            return;
        } else {
            String string10 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string10);
        }
    }

    public Object getParameter(String string) throws DOMException {
        if (string.equals("comments")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("datatype-normalization")) {
            return this.fConfiguration.getFeature(NORMALIZE_DATA) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("entities")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("namespaces")) {
            return this.fConfiguration.getFeature(NAMESPACES) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("validate")) {
            return this.fConfiguration.getFeature(VALIDATION_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("validate-if-schema")) {
            return this.fConfiguration.getFeature(DYNAMIC_VALIDATION) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("whitespace-in-element-content")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("namespace-declarations") || string.equals("cdata-sections") || string.equals("well-formed") || string.equals("canonical-form") || string.equals("supported-media-types-only") || string.equals("infoset") || string.equals("charset-overrides-xml-encoding")) {
            return this.fConfiguration.getFeature(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("error-handler")) {
            if (this.fErrorHandler != null) {
                return this.fErrorHandler.getErrorHandler();
            }
            return null;
        }
        if (string.equals("entity-resolver")) {
            try {
                XMLEntityResolver xMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
                if (xMLEntityResolver != null && xMLEntityResolver instanceof DOMEntityResolverWrapper) {
                    return ((DOMEntityResolverWrapper)xMLEntityResolver).getEntityResolver();
                }
                return null;
            }
            catch (XMLConfigurationException xMLConfigurationException) {}
        } else {
            if (string.equals("schema-type")) {
                return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            }
            if (string.equals("schema-location")) {
                return this.fSchemaLocation;
            }
            if (string.equals(SYMBOL_TABLE)) {
                return this.fConfiguration.getProperty(SYMBOL_TABLE);
            }
            if (string.equals("http://apache.org/xml/properties/dom/document-class-name")) {
                return this.fConfiguration.getProperty("http://apache.org/xml/properties/dom/document-class-name");
            }
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string2);
        }
        return null;
    }

    public boolean canSetParameter(String string, Object object) {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (string.equals("supported-media-types-only") || string.equals("canonical-form")) {
                return !bl;
            }
            if (string.equals("cdata-sections") || string.equals("namespace-declarations") || string.equals("well-formed") || string.equals("infoset")) {
                return bl;
            }
            if (string.equals("charset-overrides-xml-encoding") || string.equals("comments") || string.equals("datatype-normalization") || string.equals("entities") || string.equals("namespaces") || string.equals("validate") || string.equals("validate-if-schema") || string.equals("whitespace-in-element-content")) {
                return true;
            }
            try {
                this.fConfiguration.getFeature(string);
                return true;
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                return false;
            }
        }
        if (string.equals("error-handler")) {
            return object instanceof DOMErrorHandler;
        }
        if (string.equals("entity-resolver")) {
            return object instanceof DOMResourceResolver;
        }
        if (string.equals("schema-type")) {
            return object instanceof String && (object.equals(Constants.NS_XMLSCHEMA) || object.equals(Constants.NS_DTD));
        }
        if (string.equals("schema-location")) {
            return object instanceof String;
        }
        return string.equals("http://apache.org/xml/properties/dom/document-class-name");
    }

    public Document parseURI(String string) {
        block2: {
            XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
            this.fBusy = true;
            try {
                this.parse(xMLInputSource);
                this.fBusy = false;
            }
            catch (Exception exception) {
                this.fBusy = false;
                if (this.fErrorHandler == null) break block2;
                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                dOMErrorImpl.fException = exception;
                dOMErrorImpl.fMessage = exception.getMessage();
                dOMErrorImpl.fSeverity = (short)2;
                this.fErrorHandler.getErrorHandler().handleError(dOMErrorImpl);
            }
        }
        return this.getDocument();
    }

    public Document parse(DOMInput dOMInput) {
        block2: {
            XMLInputSource xMLInputSource = this.dom2xmlInputSource(dOMInput);
            this.fBusy = true;
            try {
                this.parse(xMLInputSource);
                this.fBusy = false;
            }
            catch (Exception exception) {
                this.fBusy = false;
                if (this.fErrorHandler == null) break block2;
                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                dOMErrorImpl.fException = exception;
                dOMErrorImpl.fMessage = exception.getMessage();
                dOMErrorImpl.fSeverity = (short)2;
                this.fErrorHandler.getErrorHandler().handleError(dOMErrorImpl);
            }
        }
        return this.getDocument();
    }

    public Node parseWithContext(DOMInput dOMInput, Node node, short s) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(DOMInput dOMInput) {
        XMLInputSource xMLInputSource = null;
        xMLInputSource = dOMInput.getStringData() != null ? new XMLInputSource(dOMInput.getPublicId(), dOMInput.getSystemId(), dOMInput.getBaseURI(), new StringReader(dOMInput.getStringData()), "UTF-16") : (dOMInput.getCharacterStream() != null ? new XMLInputSource(dOMInput.getPublicId(), dOMInput.getSystemId(), dOMInput.getBaseURI(), dOMInput.getCharacterStream(), "UTF-16") : (dOMInput.getByteStream() != null ? new XMLInputSource(dOMInput.getPublicId(), dOMInput.getSystemId(), dOMInput.getBaseURI(), dOMInput.getByteStream(), dOMInput.getEncoding()) : new XMLInputSource(dOMInput.getPublicId(), dOMInput.getSystemId(), dOMInput.getBaseURI())));
        return xMLInputSource;
    }

    public boolean getAsync() {
        return false;
    }

    public boolean getBusy() {
        return this.fBusy;
    }
}

