/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.xinclude.BadParseAttributeException;
import nu.xom.xinclude.CircularIncludeException;
import nu.xom.xinclude.EncodingHeuristics;
import nu.xom.xinclude.MisplacedFallbackException;
import nu.xom.xinclude.MissingHrefException;
import nu.xom.xinclude.XIncludeException;
import nu.xom.xinclude.XPointer;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

public class XIncluder {
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";

    private XIncluder() {
    }

    public static Document resolve(Document in) throws BadParseAttributeException, CircularIncludeException, IOException, MissingHrefException, ParsingException, UnsupportedEncodingException, XIncludeException {
        return XIncluder.resolve(in, new Builder());
    }

    public static Document resolve(Document in, Builder builder) throws BadParseAttributeException, CircularIncludeException, IOException, MissingHrefException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Document copy = new Document(in);
        XIncluder.resolveInPlace(copy, builder);
        return copy;
    }

    public static void resolveInPlace(Document in) throws BadParseAttributeException, CircularIncludeException, IOException, MissingHrefException, ParsingException, UnsupportedEncodingException, XIncludeException {
        XIncluder.resolveInPlace(in, new Builder());
    }

    public static void resolveInPlace(Document in, Builder builder) throws BadParseAttributeException, CircularIncludeException, IOException, MissingHrefException, ParsingException, UnsupportedEncodingException, XIncludeException {
        XIncluder.resolveInPlace(in, builder, new Stack());
    }

    public static void resolveInPlace(Nodes in) throws IOException, ParsingException, XIncludeException {
        XIncluder.resolveInPlace(in, new Builder());
    }

    public static void resolveInPlace(Nodes in, Builder builder) throws IOException, ParsingException, XIncludeException {
        for (int i = 0; i < in.size(); ++i) {
            Node child = in.get(i);
            if (child instanceof Element) {
                XIncluder.resolve((Element)child, builder, new Stack());
                continue;
            }
            if (!(child instanceof Document)) continue;
            XIncluder.resolveInPlace((Document)child, builder, new Stack());
        }
    }

    private static void resolveInPlace(Document in, Builder builder, Stack baseURLs) throws IOException, ParsingException, XIncludeException {
        String base = in.getBaseURI();
        if (baseURLs.indexOf(base) != -1) {
            throw new CircularIncludeException("Tried to include the already included document" + base + " from " + in.getBaseURI(), in.getBaseURI());
        }
        baseURLs.push(base);
        XIncluder.resolve(in.getRootElement(), builder, baseURLs);
        baseURLs.pop();
    }

    private static void resolve(Element element, Builder builder, Stack baseURLs) throws IOException, ParsingException, XIncludeException {
        block22: {
            if (XIncluder.isIncludeElement(element)) {
                String parse = element.getAttributeValue("parse");
                if (parse == null) {
                    parse = "xml";
                }
                String encoding = element.getAttributeValue("encoding");
                String href = element.getAttributeValue("href");
                if (href == null) {
                    throw new MissingHrefException("Missing href attribute", element.getDocument().getBaseURI());
                }
                href = XIncluder.convertToURI(href);
                XIncluder.testForMultipleFallbacks(element);
                ParentNode parent = element.getParent();
                String base = element.getBaseURI();
                URL baseURL = null;
                if (base != null) {
                    try {
                        baseURL = new URL(base);
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                }
                try {
                    URL url = baseURL != null ? new URL(baseURL, href) : new URL(href);
                    if (parse.equals("xml")) {
                        Node child;
                        Nodes replacements = XIncluder.downloadXMLDocument(url, builder, baseURLs);
                        for (int i = 0; i < replacements.size(); ++i) {
                            Node child2 = replacements.get(i);
                            if (!(child2 instanceof Element)) continue;
                            String noFragment = url.toExternalForm();
                            if (noFragment.indexOf(35) >= 0) {
                                noFragment = noFragment.substring(0, noFragment.indexOf(35));
                            }
                            Element baseless = (Element)child2;
                            Attribute baseAttribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", noFragment);
                            baseless.addAttribute(baseAttribute);
                        }
                        if (parent instanceof Element) {
                            int position = parent.indexOf(element);
                            for (int i = 0; i < replacements.size(); ++i) {
                                child = replacements.get(i);
                                parent.insertChild(child, position + i);
                            }
                            element.detach();
                        } else {
                            Document doc = (Document)parent;
                            int i = 0;
                            while (true) {
                                child = replacements.get(i);
                                ++i;
                                if (child instanceof Element) break;
                                doc.insertChild(child, doc.indexOf(element));
                            }
                            doc.setRootElement((Element)child);
                            Element root = doc.getRootElement();
                            int position = doc.indexOf(root);
                            for (int j = i; j < replacements.size(); ++j) {
                                doc.insertChild(replacements.get(j), position + 1 + j - i);
                            }
                        }
                        break block22;
                    }
                    if (parse.equals("text")) {
                        Text replacement = XIncluder.downloadTextDocument(url, encoding, builder);
                        parent.replaceChild(element, replacement);
                        break block22;
                    }
                    throw new BadParseAttributeException("Bad value for parse attribute: " + parse, element.getDocument().getBaseURI());
                }
                catch (IOException ex) {
                    XIncluder.processFallback(element, builder, baseURLs, parent, ex);
                }
                catch (XPointerSyntaxException ex) {
                    XIncluder.processFallback(element, builder, baseURLs, parent, ex);
                }
                catch (XPointerResourceException ex) {
                    XIncluder.processFallback(element, builder, baseURLs, parent, ex);
                }
            } else {
                if (XIncluder.isFallbackElement(element)) {
                    throw new MisplacedFallbackException("Fallback element outside include element", element.getDocument().getBaseURI());
                }
                Elements children = element.getChildElements();
                for (int i = 0; i < children.size(); ++i) {
                    XIncluder.resolve(children.get(i), builder, baseURLs);
                }
            }
        }
    }

    private static void testForMultipleFallbacks(Element element) throws XIncludeException {
        Elements fallbacks = element.getChildElements("fallback", XINCLUDE_NS);
        if (fallbacks.size() > 1) {
            throw new XIncludeException("Multiple fallback elements", element.getDocument().getBaseURI());
        }
        Element include = element.getFirstChildElement("include", XINCLUDE_NS);
        if (include != null) {
            throw new XIncludeException("Include element contains an include child", element.getDocument().getBaseURI());
        }
    }

    private static void processFallback(Element element, Builder builder, Stack baseURLs, ParentNode parent, Exception ex) throws XIncludeException, IOException, ParsingException {
        Elements fallbacks = element.getChildElements("fallback", XINCLUDE_NS);
        if (fallbacks.size() == 0) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            XIncludeException ex2 = new XIncludeException(ex.getMessage(), element.getDocument().getBaseURI());
            ex2.initCause(ex);
            throw ex2;
        }
        if (fallbacks.size() > 1) {
            throw new XIncludeException("Multiple fallbacks", element.getDocument().getBaseURI());
        }
        Element fallback = fallbacks.get(0);
        while (fallback.getChildCount() > 0) {
            Node child = fallback.getChild(0);
            if (child instanceof Element) {
                XIncluder.resolve((Element)child, builder, baseURLs);
            }
            child = fallback.getChild(0);
            child.detach();
            parent.insertChild(child, parent.indexOf(element));
        }
        element.detach();
    }

    private static Nodes downloadXMLDocument(URL source, Builder builder, Stack baseURLs) throws IOException, ParsingException, XIncludeException, XPointerSyntaxException, XPointerResourceException {
        int i;
        Nodes included;
        Document doc = builder.build(source.openStream(), source.toExternalForm());
        String fragmentID = source.getRef();
        if (fragmentID != null && fragmentID.length() != 0) {
            included = XPointer.resolve(doc, fragmentID);
            XIncluder.resolveInPlace(included);
        } else {
            XIncluder.resolveInPlace(doc, builder, baseURLs);
            included = new Nodes();
            for (i = 0; i < doc.getChildCount(); ++i) {
                Node child = doc.getChild(i);
                if (child instanceof DocType) continue;
                included.append(child);
            }
        }
        doc.setRootElement(new Element("f"));
        for (i = 0; i < included.size(); ++i) {
            included.get(i).detach();
        }
        return included;
    }

    private static Text downloadTextDocument(URL source, String encoding, Builder builder) throws IOException {
        int c;
        String version;
        if (encoding == null || encoding.length() == 0) {
            encoding = "UTF-8";
        }
        URLConnection uc = source.openConnection();
        String encodingFromHeader = uc.getContentEncoding();
        String contentType = uc.getContentType();
        int contentLength = uc.getContentLength();
        if (contentLength < 0) {
            contentLength = 1024;
        }
        BufferedInputStream in = new BufferedInputStream(uc.getInputStream());
        if (encodingFromHeader != null) {
            encoding = encodingFromHeader;
        } else if (contentType != null && ((contentType = contentType.toLowerCase()).equals("text/xml") || contentType.equals("application/xml") || contentType.startsWith("text/") && contentType.endsWith("+xml") || contentType.startsWith("application/") && contentType.endsWith("+xml"))) {
            encoding = EncodingHeuristics.readEncodingFromStream(in);
        }
        if (encoding.equalsIgnoreCase("UTF-16") && ((version = System.getProperty("java.version")).startsWith("1.2") || version.startsWith("1.1"))) {
            ((InputStream)in).mark(2);
            int first = ((InputStream)in).read();
            encoding = first == 255 ? "UnicodeLittle" : "UnicodeBig";
            ((InputStream)in).reset();
        }
        InputStreamReader reader = new InputStreamReader((InputStream)in, encoding);
        StringBuffer s = new StringBuffer(contentLength);
        while ((c = reader.read()) != -1) {
            s.append((char)c);
        }
        NodeFactory factory = builder.getNodeFactory();
        if (factory != null) {
            return factory.makeText(s.toString());
        }
        return new Text(s.toString());
    }

    private static boolean isIncludeElement(Element element) {
        return element.getLocalName().equals("include") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }

    private static boolean isFallbackElement(Element element) {
        return element.getLocalName().equals("fallback") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }

    private static String convertToURI(String iri) {
        try {
            byte[] utf8Data = iri.getBytes("UTF-8");
            StringBuffer uri = new StringBuffer(utf8Data.length);
            for (int i = 0; i < utf8Data.length; ++i) {
                if (XIncluder.needsEscaping(utf8Data[i])) {
                    uri.append(XIncluder.hexEscape(utf8Data[i]));
                    continue;
                }
                uri.append((char)utf8Data[i]);
            }
            return uri.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("VM is broken. It does not support UTF-8.");
        }
    }

    private static boolean needsEscaping(byte c) {
        if (c <= 32) {
            return true;
        }
        if (c <= 33) {
            return false;
        }
        if (c <= 34) {
            return true;
        }
        if (c <= 59) {
            return false;
        }
        if (c <= 60) {
            return true;
        }
        if (c <= 61) {
            return false;
        }
        if (c <= 62) {
            return true;
        }
        if (c <= 91) {
            return false;
        }
        if (c <= 92) {
            return true;
        }
        if (c <= 93) {
            return false;
        }
        if (c <= 94) {
            return true;
        }
        if (c <= 95) {
            return false;
        }
        if (c <= 96) {
            return true;
        }
        return c > 126;
    }

    private static String hexEscape(byte c) {
        StringBuffer result = new StringBuffer(3);
        result.append('%');
        if (c <= 15) {
            result.append('0');
        }
        result.append(Integer.toHexString(c));
        return result.toString();
    }
}

