/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXConverter {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;

    public SAXConverter(ContentHandler handler) {
        this.setContentHandler(handler);
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("ContentHandler must be non-null.");
        }
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void convert(Document doc) throws SAXException {
        this.contentHandler.startDocument();
        for (int i = 0; i < doc.getChildCount(); ++i) {
            this.process(doc.getChild(i));
        }
        this.contentHandler.endDocument();
    }

    private void process(Node node) throws SAXException {
        if (node instanceof Element) {
            this.convertElement((Element)node);
        } else if (node instanceof Text) {
            String data = node.getValue();
            this.contentHandler.characters(data.toCharArray(), 0, data.length());
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction instruction = (ProcessingInstruction)node;
            this.contentHandler.processingInstruction(instruction.getTarget(), instruction.getValue());
        } else if (node instanceof Comment && this.lexicalHandler != null) {
            String data = node.getValue();
            this.lexicalHandler.comment(data.toCharArray(), 0, data.length());
        } else if (node instanceof DocType && this.lexicalHandler != null) {
            DocType type = (DocType)node;
            this.lexicalHandler.startDTD(type.getRootElementName(), type.getPublicID(), type.getSystemID());
            this.lexicalHandler.endDTD();
        }
    }

    private void convertElement(Element element) throws SAXException {
        int i;
        String attPrefix;
        Attribute att;
        int i2;
        String prefix;
        for (int i3 = 0; i3 < element.getNamespaceDeclarationCount(); ++i3) {
            prefix = element.getNamespacePrefix(i3);
            this.contentHandler.startPrefixMapping(prefix, element.getNamespaceURI(prefix));
        }
        ParentNode parentNode = element.getParent();
        if (parentNode instanceof Element) {
            Element parent = (Element)parentNode;
            String prefix2 = element.getNamespacePrefix();
            if (!element.getNamespaceURI(prefix2).equals(parent.getNamespaceURI(prefix2))) {
                this.contentHandler.startPrefixMapping(prefix2, element.getNamespaceURI(prefix2));
            }
            for (i2 = 0; i2 < element.getAttributeCount(); ++i2) {
                att = element.getAttribute(i2);
                attPrefix = att.getNamespacePrefix();
                if (element.getNamespaceURI(attPrefix).equals(parent.getNamespaceURI(attPrefix)) || element.getNamespacePrefix().equals(attPrefix)) continue;
                this.contentHandler.startPrefixMapping(attPrefix, element.getNamespaceURI(attPrefix));
            }
        } else {
            prefix = element.getNamespacePrefix();
            if (!prefix.equals("")) {
                this.contentHandler.startPrefixMapping(prefix, element.getNamespaceURI());
            }
            for (int i4 = 0; i4 < element.getAttributeCount(); ++i4) {
                Attribute att2 = element.getAttribute(i4);
                String attPrefix2 = att2.getNamespacePrefix();
                if (attPrefix2.equals("") || attPrefix2.equals(element.getNamespacePrefix())) continue;
                this.contentHandler.startPrefixMapping(attPrefix2, att2.getNamespaceURI());
            }
        }
        AttributesImpl saxAttributes = new AttributesImpl();
        for (i = 0; i < element.getAttributeCount(); ++i) {
            Attribute attribute = element.getAttribute(i);
            saxAttributes.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getQualifiedName(), SAXConverter.getSAXType(attribute), attribute.getValue());
        }
        this.contentHandler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName(), saxAttributes);
        for (i = 0; i < element.getChildCount(); ++i) {
            this.process(element.getChild(i));
        }
        this.contentHandler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName());
        for (i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            String prefix3 = element.getNamespacePrefix(i);
            this.contentHandler.endPrefixMapping(prefix3);
        }
        if (parentNode instanceof Element) {
            Element parent = (Element)parentNode;
            String prefix4 = element.getNamespacePrefix();
            if (!element.getNamespaceURI(prefix4).equals(parent.getNamespaceURI(prefix4))) {
                this.contentHandler.endPrefixMapping(prefix4);
            }
            for (int i5 = 0; i5 < element.getAttributeCount(); ++i5) {
                Attribute att3 = element.getAttribute(i5);
                String attPrefix3 = att3.getNamespacePrefix();
                if (element.getNamespaceURI(attPrefix3).equals(parent.getNamespaceURI(attPrefix3)) || element.getNamespacePrefix().equals(attPrefix3)) continue;
                this.contentHandler.endPrefixMapping(attPrefix3);
            }
        } else {
            String prefix5 = element.getNamespacePrefix();
            if (!prefix5.equals("")) {
                this.contentHandler.endPrefixMapping(prefix5);
            }
            for (i2 = 0; i2 < element.getAttributeCount(); ++i2) {
                att = element.getAttribute(i2);
                attPrefix = att.getNamespacePrefix();
                if (attPrefix.equals("") || attPrefix.equals(element.getNamespacePrefix())) continue;
                this.contentHandler.endPrefixMapping(attPrefix);
            }
        }
    }

    private static String getSAXType(Attribute attribute) {
        Attribute.Type type = attribute.getType();
        if (type == Attribute.Type.UNDECLARED) {
            return "CDATA";
        }
        if (type == Attribute.Type.CDATA) {
            return "CDATA";
        }
        if (type == Attribute.Type.ID) {
            return "ID";
        }
        if (type == Attribute.Type.IDREF) {
            return "IDREF";
        }
        if (type == Attribute.Type.IDREFS) {
            return "IDREFS";
        }
        if (type == Attribute.Type.NMTOKEN) {
            return "NMTOKEN";
        }
        if (type == Attribute.Type.NMTOKENS) {
            return "NMTOKENS";
        }
        if (type == Attribute.Type.ENTITY) {
            return "ENTITY";
        }
        if (type == Attribute.Type.ENTITIES) {
            return "ENTITIES";
        }
        if (type == Attribute.Type.NOTATION) {
            return "NOTATION";
        }
        return "CDATA";
    }
}

