/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;

public class CanonicalXMLSerializer
extends Serializer {
    private boolean withComments;
    private static Comparator comparator = new AttributeComparator();

    public CanonicalXMLSerializer(OutputStream out) {
        this(out, true);
    }

    public CanonicalXMLSerializer(OutputStream out, boolean withComments) {
        super(out);
        this.setLineSeparator("\n");
        this.withComments = withComments;
    }

    public final void write(Document doc) throws IOException {
        int position = 0;
        while (true) {
            Node child = doc.getChild(position);
            this.write(child);
            ++position;
            if (child instanceof ProcessingInstruction) {
                this.breakLine();
                continue;
            }
            if (child instanceof Comment && this.withComments) {
                this.breakLine();
                continue;
            }
            if (child instanceof Element) break;
        }
        for (int i = position; i < doc.getChildCount(); ++i) {
            Node child = doc.getChild(i);
            if (child instanceof ProcessingInstruction) {
                this.breakLine();
            } else if (child instanceof Comment && this.withComments) {
                this.breakLine();
            }
            this.write(child);
        }
        this.flush();
    }

    protected final void write(Element element) throws IOException {
        this.writeStartTag(element, false);
        for (int i = 0; i < element.getChildCount(); ++i) {
            this.write(element.getChild(i));
        }
        this.writeEndTag(element);
    }

    protected void writeStartTag(Element element, boolean isEmpty) throws IOException {
        this.writeRaw("<");
        this.writeRaw(element.getQualifiedName());
        String prefix = element.getNamespacePrefix();
        ParentNode parent = element.getParent();
        String parentURI = "";
        if (parent instanceof Element) {
            parentURI = ((Element)parent).getNamespaceURI(prefix);
        }
        Element parentElement = null;
        if (parent instanceof Element) {
            parentElement = (Element)parent;
        }
        for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            String additionalPrefix = element.getNamespacePrefix(i);
            if ("xml".equals(additionalPrefix)) continue;
            String uri = element.getNamespaceURI(additionalPrefix);
            if (parentElement != null ? uri.equals(parentElement.getNamespaceURI(additionalPrefix)) : uri.equals("")) continue;
            this.writeRaw(" ");
            this.writeNamespaceDeclaration(additionalPrefix, uri);
        }
        Attribute[] sorted = this.sortAttributes(element);
        for (int i = 0; i < sorted.length; ++i) {
            this.writeRaw(" ");
            this.write(sorted[i]);
        }
        this.writeRaw(">");
    }

    protected void write(Attribute attribute) throws IOException {
        this.writeRaw(attribute.getQualifiedName());
        this.writeRaw("=\"");
        this.writeRaw(this.prepareAttributeValue(attribute));
        this.writeRaw("\"");
    }

    protected void writeEndTag(Element element) throws IOException {
        this.writeRaw("</");
        this.writeRaw(element.getQualifiedName());
        this.writeRaw(">");
    }

    private Attribute[] sortAttributes(Element element) {
        Attribute[] result = new Attribute[element.getAttributeCount()];
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            result[i] = element.getAttribute(i);
        }
        Arrays.sort(result, comparator);
        return result;
    }

    private String prepareAttributeValue(Attribute attribute) {
        String value = attribute.getValue();
        StringBuffer result = new StringBuffer(value.length());
        if (attribute.getType().equals(Attribute.Type.CDATA) || attribute.getType().equals(Attribute.Type.UNDECLARED)) {
            char[] data = value.toCharArray();
            for (int i = 0; i < data.length; ++i) {
                char c = data[i];
                if (c == '\t') {
                    result.append("&#x9;");
                    continue;
                }
                if (c == '\n') {
                    result.append("&#xA;");
                    continue;
                }
                if (c == '\r') {
                    result.append("&#xD;");
                    continue;
                }
                if (c == '\"') {
                    result.append("&quot;");
                    continue;
                }
                if (c == '&') {
                    result.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    result.append("&lt;");
                    continue;
                }
                result.append(c);
            }
        } else {
            char[] data = value.toCharArray();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == ' ') {
                    if (i == 0 || data[i - 1] == ' ') continue;
                    result.append(data[i]);
                    continue;
                }
                if (data[i] == '\t') {
                    result.append("&#x9;");
                    continue;
                }
                if (data[i] == '\n') {
                    result.append("&#xA;");
                    continue;
                }
                if (data[i] == '\r') {
                    result.append("&#xD;");
                    continue;
                }
                if (data[i] == '\"') {
                    result.append("&quot;");
                    continue;
                }
                if (data[i] == '&') {
                    result.append("&amp;");
                    continue;
                }
                if (data[i] == '<') {
                    result.append("&lt;");
                    continue;
                }
                result.append(data[i]);
            }
        }
        return result.toString();
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    protected final void write(Text text) throws IOException {
        String input = text.getValue();
        StringBuffer result = new StringBuffer(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\r') {
                result.append("&#xD;");
                continue;
            }
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            result.append(c);
        }
        this.writeRaw(result.toString());
    }

    protected final void write(Comment comment) throws IOException {
        if (this.withComments) {
            super.write(comment);
        }
    }

    protected void writeXMLDeclaration() {
    }

    protected final void write(DocType doctype) {
    }

    public final int getIndent() {
        return 0;
    }

    public final void setIndent(int indent) {
        if (indent != 0) {
            throw new IllegalArgumentException("Canonical XML does not allow indenting.");
        }
    }

    public final String getLineSeparator() {
        return "\n";
    }

    public final void setLineSeparator(String lineSeparator) {
        if (!"\n".equals(lineSeparator)) {
            throw new IllegalArgumentException("Canonical XML requires that the line separator be \n.");
        }
        super.setLineSeparator("\n");
    }

    public final int getMaxLength() {
        return -1;
    }

    public final void setMaxLength(int maxLength) {
        if (maxLength > 0) {
            throw new IllegalArgumentException("Canonical XML does not allow line wrapping.");
        }
    }

    public final boolean getPreserveBaseURI() {
        return false;
    }

    public final void setPreserveBaseURI(boolean preserve) {
        if (preserve) {
            throw new IllegalArgumentException("Canonical XML does not preserve the base URI.");
        }
    }

    public final void setUnicodeNormalizationFormC(boolean normalize) {
        if (normalize) {
            throw new IllegalArgumentException("Normalization and canonicalization are incompatible.");
        }
    }

    public final boolean getUnicodeNormalizationFormC() {
        return false;
    }

    private static class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            String namespace2;
            Attribute a1 = (Attribute)o1;
            Attribute a2 = (Attribute)o2;
            String namespace1 = a1.getNamespaceURI();
            if (namespace1.equals(namespace2 = a2.getNamespaceURI())) {
                return a1.getLocalName().compareTo(a2.getLocalName());
            }
            if (namespace1.equals("")) {
                return -1;
            }
            if (namespace2.equals("")) {
                return 1;
            }
            return namespace1.compareTo(namespace2);
        }
    }
}

