/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class XOMHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    private Document document;
    private String documentBaseURI;
    private ParentNode parent;
    private ParentNode current;
    private Stack parents;
    private boolean inProlog;
    private int position;
    private Locator locator;
    private DocType doctype;
    private StringBuffer internalDTDSubset;
    private NodeFactory factory;
    private StringBuffer buffer;
    private boolean isIgnorable = false;
    private boolean inDTD = false;
    private boolean inExternalSubset = false;
    private boolean inCDATA = false;
    private boolean finishedCDATA = false;

    XOMHandler(NodeFactory factory) {
        if (factory == null) {
            throw new NullPointerException("Factory cannot be null");
        }
        this.factory = factory;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    Document getDocument() {
        return this.document;
    }

    public void startDocument() {
        this.document = this.factory.makeDocument();
        this.parent = this.document;
        this.current = this.document;
        this.parents = new Stack();
        this.parents.push(this.document);
        this.inProlog = true;
        this.position = 0;
        this.buffer = new StringBuffer();
        this.doctype = null;
        if (this.locator != null) {
            this.documentBaseURI = this.locator.getSystemId();
            this.document.setBaseURI(this.documentBaseURI);
        }
    }

    public void endDocument() {
        this.factory.endDocument(this.document);
        this.parents.pop();
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        Element element;
        if (this.parent != this.document) {
            element = this.factory.startMakingElement(qualifiedName, namespaceURI);
        } else {
            element = this.factory.makeRootElement(qualifiedName, namespaceURI);
            if (element == null) {
                throw new NullPointerException("Factory failed to create root element.");
            }
            this.document.setRootElement(element);
            this.inProlog = false;
        }
        this.current = element;
        this.parents.push(element);
        if (element != null) {
            String qName;
            int i;
            String baseURI;
            this.flushText();
            if (this.parent != this.document) {
                this.parent.appendChild(element);
            }
            if (this.locator != null && (baseURI = this.locator.getSystemId()) != null && !baseURI.equals(this.documentBaseURI)) {
                element.setActualBaseURI(baseURI);
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                String value;
                String namespace;
                Attribute attribute;
                qName = attributes.getQName(i);
                if (qName.startsWith("xmlns:") || qName.equals("xmlns") || (attribute = this.factory.makeAttribute(qName, namespace = attributes.getURI(i), value = attributes.getValue(i), XOMHandler.convertStringToType(attributes.getType(i)))) == null) continue;
                element.addAttribute(attribute);
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                String namespacePrefix;
                String currentValue;
                String namespaceName;
                qName = attributes.getQName(i);
                if (qName.startsWith("xmlns:")) {
                    namespaceName = attributes.getValue(i);
                    if (namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = qName.substring(6)))) continue;
                    element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                    continue;
                }
                if (!qName.equals("xmlns") || (namespaceName = attributes.getValue(i)).equals(currentValue = element.getNamespaceURI(namespacePrefix = ""))) continue;
                element.addNamespaceDeclaration(namespacePrefix, namespaceName);
            }
            this.parent = element;
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        this.current = (ParentNode)this.parents.pop();
        if (this.current != null) {
            this.flushText();
            ParentNode temp = this.current.getParent();
            Element result = this.factory.finishMakingElement((Element)this.current);
            if (result != this.current) {
                temp.removeChild(temp.getChildCount() - 1);
                if (result != null) {
                    temp.appendChild(result);
                }
            }
            this.parent = temp;
        }
    }

    private static Attribute.Type convertStringToType(String saxType) {
        if (saxType.equals("CDATA")) {
            return Attribute.Type.CDATA;
        }
        if (saxType.equals("ID")) {
            return Attribute.Type.ID;
        }
        if (saxType.equals("IDREF")) {
            return Attribute.Type.IDREF;
        }
        if (saxType.equals("IDREFS")) {
            return Attribute.Type.IDREFS;
        }
        if (saxType.equals("NMTOKEN")) {
            return Attribute.Type.NMTOKEN;
        }
        if (saxType.equals("NMTOKENS")) {
            return Attribute.Type.NMTOKENS;
        }
        if (saxType.equals("ENTITY")) {
            return Attribute.Type.ENTITY;
        }
        if (saxType.equals("ENTITIES")) {
            return Attribute.Type.ENTITIES;
        }
        if (saxType.equals("NOTATION")) {
            return Attribute.Type.NOTATION;
        }
        if (saxType.equals("ENUMERATION")) {
            return Attribute.Type.ENUMERATION;
        }
        if (saxType.startsWith("(")) {
            return Attribute.Type.ENUMERATION;
        }
        return Attribute.Type.UNDECLARED;
    }

    public void characters(char[] text, int start, int length) {
        this.buffer.append(text, start, length);
        if (this.finishedCDATA && length > 0) {
            this.inCDATA = false;
        }
    }

    private void flushText() {
        if (this.buffer.length() > 0) {
            Text data = !this.isIgnorable && !this.inCDATA ? this.factory.makeText(this.buffer.toString()) : (this.inCDATA ? this.factory.makeCDATASection(this.buffer.toString()) : this.factory.makeWhiteSpaceInElementContent(this.buffer.toString()));
            if (data != null) {
                this.parent.appendChild(data);
            }
            this.buffer = new StringBuffer();
        }
        this.isIgnorable = false;
        this.inCDATA = false;
        this.finishedCDATA = false;
    }

    public void ignorableWhitespace(char[] text, int start, int length) {
        this.characters(text, start, length);
        this.isIgnorable = true;
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstruction instruction = this.factory.makeProcessingInstruction(target, data);
        if (instruction != null) {
            if (!this.inDTD) {
                this.flushText();
                if (this.inProlog) {
                    this.parent.insertChild(instruction, this.position);
                    ++this.position;
                } else {
                    this.parent.appendChild(instruction);
                }
            } else if (!this.inExternalSubset) {
                this.internalDTDSubset.append(instruction.toXML());
                this.internalDTDSubset.append('\n');
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
        throw new XMLException("Could not resolve entity " + name);
    }

    public void startDTD(String rootName, String publicID, String systemID) {
        this.inDTD = true;
        DocType doctype = this.factory.makeDocType(rootName, publicID, systemID);
        if (doctype != null) {
            this.internalDTDSubset = new StringBuffer();
            this.document.insertChild(doctype, this.position);
            ++this.position;
            this.doctype = doctype;
        }
    }

    public void endDTD() {
        this.inDTD = false;
        if (this.doctype != null) {
            this.doctype.setInternalDTDSubset(this.internalDTDSubset.toString());
        }
    }

    public void startEntity(String name) {
        if (name.equals("[dtd]")) {
            this.inExternalSubset = true;
        }
    }

    public void endEntity(String name) {
        if (name.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }

    public void startCDATA() {
        if (this.buffer.length() == 0) {
            this.inCDATA = true;
        }
        this.finishedCDATA = false;
    }

    public void endCDATA() {
        this.finishedCDATA = true;
    }

    public void comment(char[] text, int start, int length) {
        if (this.inDTD && this.inExternalSubset) {
            return;
        }
        Comment comment = this.factory.makeComment(new String(text, start, length));
        if (comment != null) {
            if (!this.inDTD) {
                this.flushText();
                if (this.inProlog) {
                    this.parent.insertChild(comment, this.position);
                    ++this.position;
                } else {
                    this.parent.appendChild(comment);
                }
            } else if (this.inDTD) {
                this.internalDTDSubset.append(comment.toXML());
                this.internalDTDSubset.append('\n');
            }
        }
    }

    public void elementDecl(String name, String model) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!ELEMENT ");
            this.internalDTDSubset.append(name);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(model);
            this.internalDTDSubset.append('>');
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String mode, String defaultValue) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!ATTLIST ");
            this.internalDTDSubset.append(elementName);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(attributeName);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(type);
            this.internalDTDSubset.append(' ');
            if (mode != null) {
                this.internalDTDSubset.append(mode);
            }
            if (defaultValue != null) {
                this.internalDTDSubset.append('\"');
                this.internalDTDSubset.append(defaultValue);
                this.internalDTDSubset.append("\"");
            }
            this.internalDTDSubset.append(">");
        }
    }

    public void internalEntityDecl(String name, String value) {
        if (!this.inExternalSubset && this.doctype != null && !name.startsWith("%")) {
            this.internalDTDSubset.append("  <!ENTITY ");
            this.internalDTDSubset.append(name);
            this.internalDTDSubset.append(" \"");
            this.internalDTDSubset.append(value);
            this.internalDTDSubset.append("\">");
        }
    }

    public void externalEntityDecl(String name, String publicID, String systemID) {
        if (!this.inExternalSubset && this.doctype != null && !name.startsWith("%")) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (publicID != null) {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(systemID);
            } else {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
            }
            this.internalDTDSubset.append("\">");
        }
    }

    public void notationDecl(String name, String publicID, String systemID) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!NOTATION ");
            this.internalDTDSubset.append(name);
            if (publicID != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append('\"');
                if (systemID != null) {
                    this.internalDTDSubset.append(" \"");
                    this.internalDTDSubset.append(systemID);
                    this.internalDTDSubset.append('\"');
                }
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append('>');
        }
    }

    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (publicID != null) {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(notationName);
            } else {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(notationName);
            }
            this.internalDTDSubset.append('>');
        }
    }
}

