/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.EBCDICWriter;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.TextWriter;
import nu.xom.TextWriterFactory;
import nu.xom.UnicodeWriter;
import nu.xom.XMLException;

public class Serializer {
    private TextWriter escaper;
    private boolean preserveBaseURI = false;

    public Serializer(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("Null OutputStream");
        }
        try {
            Writer writer = new OutputStreamWriter(out, "UTF-8");
            writer = new BufferedWriter(writer);
            this.escaper = TextWriterFactory.getTextWriter(writer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("The VM is broken. It does not understand UTF-8.");
        }
    }

    public Serializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (out == null) {
            throw new NullPointerException("Null OutputStream");
        }
        if (encoding == null) {
            throw new NullPointerException("Null encoding");
        }
        this.setOutputStream(out, encoding);
    }

    public void setOutputStream(OutputStream out) throws IOException {
        this.flush();
        int maxLength = this.getMaxLength();
        int indent = this.getIndent();
        String lineSeparator = this.getLineSeparator();
        boolean nfc = this.getUnicodeNormalizationFormC();
        String encoding = this.escaper.getEncoding();
        this.setOutputStream(out, encoding);
        this.setIndent(indent);
        this.setMaxLength(maxLength);
        this.setUnicodeNormalizationFormC(nfc);
        this.setLineSeparator(lineSeparator);
    }

    private void setOutputStream(OutputStream out, String encoding) throws UnsupportedEncodingException {
        Writer writer = encoding.equals("IBM037") || encoding.equals("CP037") || encoding.equals("EBCDIC-CP-US") || encoding.equals("EBCDIC-CP-CA") || encoding.equals("EBCDIC-CP-WA") || encoding.equals("EBCDIC-CP-NL") || encoding.equals("CSIBM037") ? new EBCDICWriter(out) : (encoding.equals("UTF-16") || encoding.equals("ISO-10646-UCS-2") ? new OutputStreamWriter(out, "UnicodeBig") : new OutputStreamWriter(out, encoding));
        writer = new BufferedWriter(writer);
        this.escaper = TextWriterFactory.getTextWriter(writer, encoding);
    }

    public void write(Document doc) throws IOException {
        this.escaper.reset();
        this.writeXMLDeclaration();
        for (int i = 0; i < doc.getChildCount(); ++i) {
            this.write(doc.getChild(i));
            this.escaper.breakLine();
        }
        this.escaper.flush();
    }

    public static void write(Document doc, OutputStream out) throws IOException {
        Serializer serializer = new Serializer(out);
        serializer.write(doc);
        serializer.flush();
    }

    protected void writeXMLDeclaration() throws IOException {
        this.escaper.writeMarkup("<?xml version=\"1.0\" encoding=\"");
        this.escaper.writeMarkup(this.escaper.getEncoding());
        this.escaper.writeMarkup("\"?>");
        this.escaper.breakLine();
    }

    private int isWhiteSpaceSignificant(ParentNode node) {
        if (node == null) {
            return -1;
        }
        if (node.isDocument()) {
            return -1;
        }
        Element element = (Element)node;
        String xmlSpace = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
        if ("preserve".equals(xmlSpace)) {
            return 1;
        }
        if ("default".equals(xmlSpace)) {
            return 0;
        }
        return this.isWhiteSpaceSignificant(element.getParent());
    }

    protected void write(Element element) throws IOException {
        if (this.escaper.isIndenting() && !this.escaper.isPreserveSpace()) {
            this.escaper.breakLine();
        }
        if (element.hasChildren()) {
            Node firstChild;
            this.writeStartTag(element);
            boolean wasPreservingWhiteSpace = this.escaper.isPreserveSpace();
            String newXMLSpaceValue = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
            if (newXMLSpaceValue != null) {
                if ("preserve".equals(newXMLSpaceValue)) {
                    this.escaper.setPreserveSpace(true);
                } else if ("default".equals(newXMLSpaceValue)) {
                    this.escaper.setPreserveSpace(false);
                }
            }
            this.escaper.incrementIndent();
            for (int i = 0; i < element.getChildCount(); ++i) {
                this.write(element.getChild(i));
            }
            this.escaper.decrementIndent();
            if (!(this.escaper.getIndent() <= 0 || this.escaper.isPreserveSpace() || (firstChild = element.getChild(0)).isText() && !firstChild.getValue().trim().equals(""))) {
                this.escaper.breakLine();
            }
            this.writeEndTag(element);
            if (newXMLSpaceValue != null) {
                this.escaper.setPreserveSpace(wasPreservingWhiteSpace);
            }
        } else {
            this.writeEmptyElementTag(element);
        }
        this.escaper.flush();
    }

    protected void writeEndTag(Element element) throws IOException {
        this.escaper.writeMarkup("</");
        this.escaper.writeMarkup(element.getQualifiedName());
        this.escaper.writeMarkup(">");
    }

    protected void writeStartTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.writeMarkup('>');
    }

    protected void writeEmptyElementTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.writeMarkup("/>");
    }

    private void writeTagBeginning(Element element) throws IOException {
        this.escaper.writeMarkup('<');
        this.escaper.writeMarkup(element.getQualifiedName());
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
    }

    protected void writeAttributes(Element element) throws IOException {
        String baseValue;
        ParentNode parent = element.getParent();
        if (this.preserveBaseURI && element.getAttribute("base", "http://www.w3.org/XML/1998/namespace") == null && (baseValue = element.getBaseURI()) != null && (parent == null || parent.isDocument() || !element.getBaseURI().equals(parent.getBaseURI()))) {
            this.escaper.writeMarkup(' ');
            Attribute baseAttribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", baseValue);
            this.write(baseAttribute);
        }
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            Attribute attribute = element.getAttribute(i);
            this.escaper.writeMarkup(' ');
            this.write(attribute);
        }
    }

    protected void writeNamespaceDeclarations(Element element) throws IOException {
        ParentNode parent = element.getParent();
        for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            Element parentElement;
            String additionalPrefix = element.getNamespacePrefix(i);
            if ("xml".equals(additionalPrefix)) continue;
            String uri = element.getNamespaceURI(additionalPrefix);
            if (parent.isElement() ? uri.equals((parentElement = (Element)parent).getNamespaceURI(additionalPrefix)) : uri.equals("")) continue;
            this.escaper.writeMarkup(' ');
            this.writeNamespaceDeclaration(additionalPrefix, uri);
        }
    }

    protected void writeNamespaceDeclaration(String prefix, String uri) throws IOException {
        if ("".equals(prefix)) {
            this.escaper.writeMarkup("xmlns");
        } else {
            this.escaper.writeMarkup("xmlns:");
            this.escaper.writeMarkup(prefix);
        }
        this.escaper.writeMarkup("=\"");
        this.escaper.writePCDATA(uri);
        this.escaper.writeMarkup('\"');
    }

    protected void write(Attribute attribute) throws IOException {
        this.escaper.writeMarkup(attribute.getQualifiedName());
        this.escaper.writeMarkup("=\"");
        this.escaper.writeAttributeValue(attribute.getValue());
        this.escaper.writeMarkup("\"");
    }

    protected void write(Comment comment) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<!--");
        this.escaper.writeMarkup(comment.getValue());
        this.escaper.writeMarkup("-->");
    }

    protected void write(ProcessingInstruction instruction) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<?");
        this.escaper.writeMarkup(instruction.getTarget());
        String value = instruction.getValue();
        if (!"".equals(value)) {
            this.escaper.writeMarkup(' ');
            this.escaper.writeMarkup(value);
        }
        this.escaper.writeMarkup("?>");
    }

    protected void write(Text text) throws IOException {
        String value = text.getValue();
        if (text.isCDATASection() && text.getValue().indexOf("]]>") == -1) {
            if (!(this.escaper instanceof UnicodeWriter)) {
                for (int i = 0; i < value.length(); ++i) {
                    if (!this.escaper.needsEscaping(value.charAt(i))) continue;
                    this.escaper.writePCDATA(value);
                    return;
                }
            }
            this.escaper.writeMarkup("<![CDATA[");
            this.escaper.writeMarkup(value);
            this.escaper.writeMarkup("]]>");
        } else {
            this.escaper.writePCDATA(value);
        }
    }

    protected void write(DocType doctype) throws IOException {
        this.escaper.writeMarkup("<!DOCTYPE ");
        this.escaper.writeMarkup(doctype.getRootElementName());
        if (doctype.getPublicID() != null) {
            this.escaper.writeMarkup(" PUBLIC \"" + doctype.getPublicID() + "\" \"" + doctype.getSystemID() + "\"");
        } else if (doctype.getSystemID() != null) {
            this.escaper.writeMarkup(" SYSTEM \"" + doctype.getSystemID() + "\"");
        }
        String internalDTDSubset = doctype.getInternalDTDSubset();
        if (!internalDTDSubset.equals("")) {
            this.escaper.writeMarkup(" [");
            this.escaper.breakLine();
            this.escaper.writeMarkup(internalDTDSubset);
            this.escaper.breakLine();
            this.escaper.writeMarkup("]");
        }
        this.escaper.writeMarkup(">");
    }

    protected void write(Node node) throws IOException {
        if (node.isText()) {
            this.write((Text)node);
        } else if (node.isElement()) {
            this.write((Element)node);
        } else if (node.isComment()) {
            this.write((Comment)node);
        } else if (node.isProcessingInstruction()) {
            this.write((ProcessingInstruction)node);
        } else if (node.isDocument()) {
            this.write((Document)node);
        } else if (node.isDocType()) {
            this.write((DocType)node);
        } else {
            throw new XMLException("Serializer cannot directly serialize a " + node.getClass());
        }
    }

    protected final void writeEscaped(String text) throws IOException {
        this.escaper.writePCDATA(text);
    }

    protected final void writeAttributeValue(String value) throws IOException {
        this.escaper.writeAttributeValue(value);
    }

    protected final void writeRaw(String text) throws IOException {
        this.escaper.writeMarkup(text);
    }

    protected final void breakLine() throws IOException {
        this.escaper.breakLine();
    }

    public void flush() throws IOException {
        this.escaper.flush();
    }

    public int getIndent() {
        return this.escaper.getIndent();
    }

    public void setIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Indent cannot be negative");
        }
        this.escaper.setIndent(indent);
    }

    public String getLineSeparator() {
        return this.escaper.getLineSeparator();
    }

    public void setLineSeparator(String lineSeparator) {
        this.escaper.setLineSeparator(lineSeparator);
    }

    public int getMaxLength() {
        return this.escaper.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.escaper.setMaxLength(maxLength);
    }

    public boolean getPreserveBaseURI() {
        return this.preserveBaseURI;
    }

    public void setPreserveBaseURI(boolean preserve) {
        this.preserveBaseURI = preserve;
    }

    public String getEncoding() {
        return this.escaper.getEncoding();
    }

    public void setUnicodeNormalizationFormC(boolean normalize) {
        this.escaper.setNFC(normalize);
    }

    public boolean getUnicodeNormalizationFormC() {
        return this.escaper.getNFC();
    }

    protected final int getColumnNumber() {
        return this.escaper.getColumnNumber();
    }
}

