/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.LeafNode;
import nu.xom.Node;
import nu.xom.Verifier;

public class ProcessingInstruction
extends LeafNode {
    private String target;
    private String data;

    public ProcessingInstruction(String target, String data) {
        this.setTarget(target);
        this.setValue(data);
    }

    public ProcessingInstruction(ProcessingInstruction instruction) {
        this(instruction.target, instruction.data);
    }

    private ProcessingInstruction() {
    }

    static ProcessingInstruction build(String target, String data) {
        ProcessingInstruction result = new ProcessingInstruction();
        result.target = target;
        result.data = data;
        return result;
    }

    public final String getTarget() {
        return this.target;
    }

    public final void setTarget(String target) {
        Verifier.checkProcessingInstructionTarget(target);
        this.checkTarget(target);
        this.target = target;
    }

    protected void checkTarget(String target) {
    }

    public final void setValue(String data) {
        Verifier.checkProcessingInstructionData(data);
        this.checkValue(data);
        this.data = data;
    }

    public final String getValue() {
        return this.data;
    }

    protected void checkValue(String data) {
    }

    public final String toXML() {
        StringBuffer result = new StringBuffer("<?");
        result.append(this.target);
        result.append(' ');
        result.append(this.data);
        result.append("?>");
        return result.toString();
    }

    public Node copy() {
        return new ProcessingInstruction(this.target, this.data);
    }

    boolean isProcessingInstruction() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": target=\"" + this.target + "\"; data=\"" + this.data + "\"]";
    }
}

