/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import java.util.List;
import nu.xom.MultipleParentException;
import nu.xom.NoSuchChildException;
import nu.xom.Node;
import nu.xom.Verifier;

public abstract class ParentNode
extends Node {
    private List children;
    private String actualBaseURI;

    ParentNode() {
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return !this.children.isEmpty();
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void insertChild(Node child, int position) {
        if (child == null) {
            throw new NullPointerException("Tried to insert a null child in the tree");
        }
        if (child.getParent() != null) {
            throw new MultipleParentException(child.toString() + "Child already has a parent.");
        }
        this.checkInsertChild(child, position);
        if (this.children == null) {
            this.children = new ArrayList(1);
        }
        this.children.add(position, child);
        child.setParent(this);
    }

    protected void checkInsertChild(Node child, int position) {
    }

    public final void appendChild(Node child) {
        this.insertChild(child, this.getChildCount());
    }

    public Node getChild(int position) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        return (Node)this.children.get(position);
    }

    public int indexOf(Node child) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(child);
    }

    public Node removeChild(int position) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        Node removed = (Node)this.children.get(position);
        this.checkRemoveChild(removed, position);
        this.children.remove(position);
        removed.setParent(null);
        return removed;
    }

    public Node removeChild(Node child) {
        if (this.children == null) {
            throw new NoSuchChildException("Child does not belong to this node");
        }
        int position = this.children.indexOf(child);
        if (position == -1) {
            throw new NoSuchChildException("Child does not belong to this node");
        }
        this.checkRemoveChild(child, position);
        this.children.remove(position);
        child.setParent(null);
        return child;
    }

    protected void checkRemoveChild(Node child, int position) {
    }

    public final void replaceChild(Node oldChild, Node newChild) {
        if (this.children == null) {
            throw new NoSuchChildException("Reference node is not a child of this node.");
        }
        int position = this.children.indexOf(oldChild);
        if (position == -1) {
            throw new NoSuchChildException("Reference node is not a child of this node.");
        }
        this.removeChild(position);
        this.insertChild(newChild, position);
    }

    public abstract void setBaseURI(String var1);

    String getActualBaseURI() {
        return this.actualBaseURI;
    }

    void setActualBaseURI(String uri) {
        Verifier.checkURI(uri);
        this.actualBaseURI = uri;
    }
}

