/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import nu.xom.Attribute;
import nu.xom.Attributes;
import nu.xom.CycleException;
import nu.xom.Elements;
import nu.xom.IllegalAddException;
import nu.xom.NamespaceException;
import nu.xom.Namespaces;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.Verifier;
import nu.xom.XMLException;

public class Element
extends ParentNode {
    private String localName;
    private String prefix;
    private String URI;
    private Attributes attributes = null;
    private Namespaces namespaces = null;

    public Element(String name) {
        this(name, "");
    }

    public Element(String name, String uri) {
        String prefix = "";
        String localName = name;
        if (name.indexOf(58) >= 0) {
            prefix = name.substring(0, name.indexOf(58));
            localName = name.substring(name.indexOf(58) + 1);
        }
        this.setNamespacePrefix(prefix);
        this.setNamespaceURI(uri);
        this.setLocalName(localName);
    }

    private Element() {
    }

    static Element build(String name, String uri) {
        Element result = new Element();
        String prefix = "";
        String localName = name;
        if (name.indexOf(58) >= 0) {
            prefix = name.substring(0, name.indexOf(58));
            localName = name.substring(name.indexOf(58) + 1);
        }
        result.prefix = prefix;
        result.localName = localName;
        result.setNamespaceURI(uri);
        return result;
    }

    public Element(Element element) {
        this(element.getQualifiedName(), element.URI);
        int i;
        for (i = 0; i < element.getChildCount(); ++i) {
            Node child = element.getChild(i);
            this.appendChild(child.copy());
        }
        if (element.namespaces != null) {
            for (i = 0; i < element.namespaces.size(); ++i) {
                String prefix = element.namespaces.getPrefix(i);
                String uri = element.namespaces.getURI(prefix);
                this.addNamespaceDeclaration(prefix, uri);
            }
        }
        if (element.attributes != null) {
            for (i = 0; i < element.attributes.size(); ++i) {
                Attribute a = element.attributes.get(i);
                this.addAttribute((Attribute)a.copy());
            }
        }
        this.setActualBaseURI(element.getActualBaseURI());
    }

    public final Elements getChildElements(String name) {
        return this.getChildElements(name, "");
    }

    public final Elements getChildElements(String localName, String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (localName == null) {
            localName = "";
        }
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node child = this.getChild(i);
            if (!child.isElement() || !localName.equals((element = (Element)child).getLocalName()) && localName.length() != 0 || !namespaceURI.equals(element.getNamespaceURI())) continue;
            elements.add(element);
        }
        return elements;
    }

    public final Elements getChildElements() {
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!child.isElement()) continue;
            Element element = (Element)child;
            elements.add(element);
        }
        return elements;
    }

    public final Element getFirstChildElement(String name) {
        return this.getFirstChildElement(name, "");
    }

    public final Element getFirstChildElement(String localName, String namespaceURI) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node child = this.getChild(i);
            if (!child.isElement() || !localName.equals((element = (Element)child).getLocalName()) || !namespaceURI.equals(element.getNamespaceURI())) continue;
            return element;
        }
        return null;
    }

    public final void addAttribute(Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("Attribute already has a parent");
        }
        String attPrefix = attribute.getNamespacePrefix();
        if (attPrefix.length() != 0 && !"xml".equals(attPrefix)) {
            String existing;
            if (this.prefix.equals(attribute.getNamespacePrefix()) && !this.getNamespaceURI().equals(attribute.getNamespaceURI())) {
                throw new NamespaceException("Prefix of " + attribute.getQualifiedName() + " conflicts with element prefix " + this.prefix);
            }
            if (this.namespaces != null && (existing = this.namespaces.getURI(attribute.getNamespacePrefix())) != null && !existing.equals(attribute.getNamespaceURI())) {
                throw new NamespaceException("Attribute prefix  " + attPrefix + " conflicts with namespace declaration.");
            }
        }
        this.checkAddAttribute(attribute);
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.add(attribute);
        attribute.setParent(this);
    }

    final void fastAdd(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.fastAdd(attribute);
        attribute.setParent(this);
    }

    protected void checkAddAttribute(Attribute attribute) {
    }

    public final void removeAttribute(Attribute attribute) {
        this.checkRemoveAttribute(attribute);
        if (this.attributes == null) {
            throw new XMLException("Tried to remove attribute " + attribute.getQualifiedName() + " from non-parent element");
        }
        this.attributes.remove(attribute);
        attribute.setParent(null);
    }

    protected void checkRemoveAttribute(Attribute attribute) {
    }

    public final Attribute getAttribute(String name) {
        return this.getAttribute(name, "");
    }

    public final Attribute getAttribute(String localName, String namespaceURI) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(localName, namespaceURI);
    }

    public final String getAttributeValue(String name) {
        return this.getAttributeValue(name, "");
    }

    public final int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public final Attribute getAttribute(int index) {
        if (this.attributes == null) {
            throw new IndexOutOfBoundsException("Element does not have any attributes");
        }
        return this.attributes.get(index);
    }

    public final String getAttributeValue(String localName, String namespaceURI) {
        if (this.attributes == null) {
            return null;
        }
        Attribute attribute = this.attributes.get(localName, namespaceURI);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespaceURI(String prefix) {
        String result = this.getLocalNamespaceURI(prefix);
        if (result == null && this.getParent() != null && this.getParent().isElement()) {
            Element parent = (Element)this.getParent();
            result = parent.getNamespaceURI(prefix);
        }
        return result;
    }

    String getLocalNamespaceURI(String prefix) {
        String result;
        if (prefix.equals(this.prefix)) {
            return this.URI;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "";
        }
        if (this.namespaces != null && (result = this.namespaces.getURI(prefix)) != null) {
            return result;
        }
        if (prefix.length() != 0 && this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                Attribute a = this.attributes.get(i);
                if (!a.getNamespacePrefix().equals(prefix)) continue;
                return a.getNamespaceURI();
            }
        }
        return null;
    }

    public final void setLocalName(String localName) {
        Verifier.checkNCName(localName);
        this.checkLocalName(localName);
        this.localName = localName;
    }

    protected void checkLocalName(String localName) {
    }

    public final void setNamespaceURI(String uri) {
        String result;
        if (uri == null) {
            uri = "";
        }
        if (uri.equals(this.URI)) {
            return;
        }
        if (uri.length() == 0) {
            if (this.prefix.length() != 0) {
                throw new NamespaceException("Prefixed elements must have namespace URIs.");
            }
        } else {
            Verifier.checkAbsoluteURIReference(uri);
        }
        if (this.namespaces != null && (result = this.namespaces.getURI(this.prefix)) != null) {
            throw new NamespaceException("new URI conflicts with existing prefix");
        }
        if (uri.length() > 0 && this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                Attribute a = this.attributes.get(i);
                String attPrefix = a.getNamespacePrefix();
                if (attPrefix.length() == 0 || !a.getNamespacePrefix().equals(this.prefix)) continue;
                throw new NamespaceException("new element URI " + uri + " conflicts with attribute " + a.getQualifiedName());
            }
        }
        this.checkNamespaceURI(uri);
        this.URI = uri;
    }

    protected void checkNamespaceURI(String URI2) {
    }

    public final void setNamespacePrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.length() != 0) {
            Verifier.checkNCName(prefix);
        }
        this.checkNamespacePrefix(prefix);
        String uri = this.getLocalNamespaceURI(prefix);
        if (uri != null && !uri.equals(this.URI)) {
            throw new NamespaceException(prefix + " conflicts with existing prefix");
        }
        this.prefix = prefix;
    }

    protected void checkNamespacePrefix(String prefix) {
    }

    public final void insertChild(Node child, int position) {
        if (child.isElement()) {
            if (child == this) {
                throw new CycleException("Cannot add a node to itself");
            }
            if (child.hasChildren() && Element.isAncestor(this, child)) {
                throw new CycleException("Cannot add an ancestor as a child");
            }
            super.insertChild(child, position);
        } else if (child.isText() || child.isProcessingInstruction() || child.isComment()) {
            super.insertChild(child, position);
        } else {
            throw new IllegalAddException("Cannot add a " + child.getClass().getName() + " to an Element.");
        }
    }

    private static boolean isAncestor(Node parent, Node child) {
        if (child == parent) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        return Element.isAncestor(parent.getParent(), child);
    }

    public final void insertChild(String text, int position) {
        if (text == null) {
            throw new NullPointerException("Inserted null string");
        }
        super.insertChild(new Text(text), position);
    }

    public final void appendChild(String text) {
        this.insertChild(new Text(text), this.getChildCount());
    }

    public final void removeChildren() {
        while (this.hasChildren()) {
            this.getChild(0).detach();
        }
    }

    public final void addNamespaceDeclaration(String prefix, String uri) {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (prefix.length() != 0) {
            Verifier.checkNCName(prefix);
            Verifier.checkAbsoluteURIReference(uri);
        } else if (uri.length() != 0) {
            Verifier.checkAbsoluteURIReference(uri);
        }
        if (prefix.equals("xmlns")) {
            throw new NamespaceException("The xmlns prefix cannot bound to any URI");
        }
        if (prefix.equals("xml")) {
            if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            throw new NamespaceException("Wrong namespace URI for xml prefix: " + uri);
        }
        String currentBinding = this.getLocalNamespaceURI(prefix);
        if (currentBinding != null && !currentBinding.equals(uri)) {
            throw new NamespaceException("Additional namespace " + uri + " conflicts with existing namespace binding.");
        }
        if (prefix.length() == 0 && this.prefix.length() == 0 && !uri.equals(this.URI)) {
            throw new NamespaceException("Additional namespace " + uri + " conflicts with existing default namespace.");
        }
        this.checkAddNamespaceDeclaration(prefix, uri);
        if (this.namespaces == null) {
            this.namespaces = new Namespaces();
        }
        this.namespaces.put(prefix, uri);
    }

    protected void checkAddNamespaceDeclaration(String prefix, String uri) {
    }

    public final void removeNamespaceDeclaration(String prefix) {
        this.checkRemoveNamespaceDeclaration(prefix);
        if (this.namespaces != null) {
            this.namespaces.remove(prefix);
        }
    }

    protected void checkRemoveNamespaceDeclaration(String prefix) {
    }

    public final int getNamespaceDeclarationCount() {
        HashSet<String> allPrefixes = this.namespaces != null ? new HashSet(this.namespaces.getPrefixes()) : new HashSet<String>(3);
        allPrefixes.add(this.prefix);
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attribute att = this.getAttribute(i);
            String attPrefix = att.getNamespacePrefix();
            if (attPrefix.length() == 0 || "xml".equals(attPrefix)) continue;
            allPrefixes.add(attPrefix);
        }
        return allPrefixes.size();
    }

    public final String getNamespacePrefix(int index) {
        TreeSet<String> allPrefixes = this.namespaces != null ? new TreeSet(this.namespaces.getPrefixes()) : new TreeSet<String>();
        allPrefixes.add(this.prefix);
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attribute att = this.getAttribute(i);
            String attPrefix = att.getNamespacePrefix();
            if (attPrefix.length() == 0) continue;
            allPrefixes.add(attPrefix);
        }
        Iterator iterator = allPrefixes.iterator();
        try {
            for (int i = 0; i < index; ++i) {
                iterator.next();
            }
            return (String)iterator.next();
        }
        catch (NoSuchElementException ex) {
            throw new IndexOutOfBoundsException("No " + index + "th namespace");
        }
    }

    public final void setBaseURI(String URI2) {
        this.setActualBaseURI(URI2);
    }

    public final String getBaseURI() {
        String actualBase = this.getActualBaseURI();
        ParentNode parent = this.getParent();
        Attribute baseAttribute = this.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
        if (baseAttribute != null) {
            String base = baseAttribute.getValue();
            if ((base = Element.toURI(base)).indexOf(58) == -1) {
                if (parent == null) {
                    return base;
                }
                String parentBase = parent.getActualBaseURI();
                if (parentBase == actualBase || parentBase.equals(actualBase)) {
                    try {
                        URL u = new URL(new URL(parent.getBaseURI()), base);
                        return u.toExternalForm();
                    }
                    catch (MalformedURLException ex) {
                        return base;
                    }
                }
            }
            return base;
        }
        if (parent == null) {
            return actualBase;
        }
        if (actualBase == null) {
            return parent.getBaseURI();
        }
        if (actualBase.equals(parent.getActualBaseURI())) {
            return parent.getBaseURI();
        }
        return actualBase;
    }

    private static String toURI(String iri) {
        StringBuffer uri = new StringBuffer(iri.length());
        for (int i = 0; i < iri.length(); ++i) {
            char c = iri.charAt(i);
            if (c >= 'a' && c <= 'z') {
                uri.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                uri.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                uri.append(c);
                continue;
            }
            if (c == '/') {
                uri.append(c);
                continue;
            }
            if (c == '-') {
                uri.append(c);
                continue;
            }
            if (c == '.') {
                uri.append(c);
                continue;
            }
            if (c == '?') {
                uri.append(c);
                continue;
            }
            if (c == ':') {
                uri.append(c);
                continue;
            }
            if (c == '@') {
                uri.append(c);
                continue;
            }
            if (c == '&') {
                uri.append(c);
                continue;
            }
            if (c == '=') {
                uri.append(c);
                continue;
            }
            if (c == '+') {
                uri.append(c);
                continue;
            }
            if (c == '$') {
                uri.append(c);
                continue;
            }
            if (c == ',') {
                uri.append(c);
                continue;
            }
            if (c == '_') {
                uri.append(c);
                continue;
            }
            if (c == '!') {
                uri.append(c);
                continue;
            }
            if (c == '~') {
                uri.append(c);
                continue;
            }
            if (c == '*') {
                uri.append(c);
                continue;
            }
            if (c == '\'') {
                uri.append(c);
                continue;
            }
            if (c == '(') {
                uri.append(c);
                continue;
            }
            if (c == ')') {
                uri.append(c);
                continue;
            }
            if (c < '\u00a0') {
                uri.append('%');
                uri.append(Integer.toHexString(c));
                continue;
            }
            String s = String.valueOf(c);
            try {
                byte[] data = s.getBytes("UTF8");
                for (int j = 0; j < data.length; ++j) {
                    uri.append('%');
                    if (data[i] <= 15) {
                        uri.append('0');
                        uri.append(Integer.toHexString(data[i]));
                        continue;
                    }
                    if (data[i] > 0) {
                        uri.append(Integer.toHexString(data[i]));
                        continue;
                    }
                    uri.append(Integer.toHexString(256 + data[i]));
                }
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Broken VM: does not recognize UTF-8 encoding");
            }
        }
        return uri.toString();
    }

    public final String toXML() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(this.getQualifiedName());
        ParentNode parentNode = this.getParent();
        for (i = 0; i < this.getNamespaceDeclarationCount(); ++i) {
            Element parentElement;
            String additionalPrefix = this.getNamespacePrefix(i);
            if ("xml".equals(additionalPrefix)) continue;
            String uri = this.getNamespaceURI(additionalPrefix);
            if (parentNode != null && parentNode.isElement() ? uri.equals((parentElement = (Element)parentNode).getNamespaceURI(additionalPrefix)) : uri.length() == 0) continue;
            result.append(" xmlns");
            if (additionalPrefix.length() > 0) {
                result.append(':');
                result.append(additionalPrefix);
            }
            result.append("=\"");
            result.append(uri);
            result.append('\"');
        }
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.size(); ++i) {
                Attribute attribute = this.attributes.get(i);
                result.append(' ');
                result.append(attribute.toXML());
            }
        }
        if (this.hasChildren()) {
            result.append('>');
            for (i = 0; i < this.getChildCount(); ++i) {
                result.append(this.getChild(i).toXML());
            }
            result.append("</");
            result.append(this.getQualifiedName());
            result.append(">");
        } else {
            result.append(" />");
        }
        return result.toString();
    }

    public final String getValue() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!child.isText() && !child.isElement()) continue;
            result.append(child.getValue());
        }
        return result.toString();
    }

    public Node copy() {
        return new Element(this);
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "]";
    }

    boolean isElement() {
        return true;
    }
}

