/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.LeafNode;
import nu.xom.Node;
import nu.xom.Verifier;

public class Comment
extends LeafNode {
    private String data;

    public Comment(String data) {
        this.setValue(data);
    }

    public Comment(Comment comment) {
        this.data = comment.data;
    }

    private Comment() {
    }

    static Comment build(String data) {
        Comment result = new Comment();
        result.data = data;
        return result;
    }

    public final void setValue(String data) {
        if (data == null) {
            data = "";
        } else {
            Verifier.checkCommentData(data);
        }
        this.checkValue(data);
        this.data = data;
    }

    protected void checkValue(String data) {
    }

    public final String getValue() {
        return this.data;
    }

    public Node copy() {
        return new Comment(this.data);
    }

    public final String toXML() {
        StringBuffer result = new StringBuffer("<!--");
        result.append(this.data);
        result.append("-->");
        return result.toString();
    }

    public final String toString() {
        String value = this.getValue();
        if (value.length() <= 40) {
            return "[" + this.getClass().getName() + ": " + value + "]";
        }
        return "[" + this.getClass().getName() + ": " + value.substring(0, 35) + "...]";
    }

    boolean isComment() {
        return true;
    }
}

